/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.helper.impl;

import java.util.Set;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.helper.LogHelper;
import org.codelibs.fess.crawler.log.LogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelperImpl
implements LogHelper {
    private static final Logger logger = LoggerFactory.getLogger(LogHelperImpl.class);

    @Override
    public void log(LogType key, Object ... objs) {
        switch (key) {
            case START_THREAD: {
                this.processStartThread(objs);
                break;
            }
            case START_CRAWLING: {
                this.processStartCrawling(objs);
                break;
            }
            case CLEANUP_CRAWLING: {
                this.processCleanupCrawling(objs);
                break;
            }
            case UNSUPPORTED_URL_AT_CRAWLING_STARTED: {
                this.processUnsupportedUrlAtCrawlingStarted(objs);
                break;
            }
            case CHECK_LAST_MODIFIED: {
                this.processCheckLastModified(objs);
                break;
            }
            case NOT_MODIFIED: {
                this.processNotModified(objs);
                break;
            }
            case GET_CONTENT: {
                this.processGetContent(objs);
                break;
            }
            case REDIRECT_LOCATION: {
                this.processRedirectLocation(objs);
                break;
            }
            case PROCESS_RESPONSE: {
                this.processProcessResponse(objs);
                break;
            }
            case FINISHED_CRAWLING: {
                this.processFinishedCrawling(objs);
                break;
            }
            case PROCESS_CHILD_URLS_BY_EXCEPTION: {
                this.processProcessChildUrlsByException(objs);
                break;
            }
            case PROCESS_CHILD_URL_BY_EXCEPTION: {
                this.processProcessChildUrlByException(objs);
                break;
            }
            case CRAWLING_ACCESS_EXCEPTION: {
                this.processCrawlingAccessException(objs);
                break;
            }
            case CRAWLING_EXCETPION: {
                this.processCrawlingException(objs);
                break;
            }
            case NO_URL_IN_QUEUE: {
                this.processNoUrlInQueue(objs);
                break;
            }
            case FINISHED_THREAD: {
                this.processFinishedThread(objs);
                break;
            }
            case NO_RESPONSE_PROCESSOR: {
                this.processNoResponseProcessor(objs);
                break;
            }
            case NO_RULE: {
                this.processNoRule(objs);
                break;
            }
            case SYSTEM_ERROR: {
                this.processSystemError(objs);
                break;
            }
            default: {
                this.processDefault(objs);
            }
        }
    }

    protected void processDefault(Object ... objs) {
    }

    protected void processSystemError(Object ... objs) {
        Throwable t = (Throwable)objs[0];
        if (logger.isErrorEnabled()) {
            logger.error("System Error.", t);
        }
    }

    protected void processNoRule(Object ... objs) {
        ResponseData responseData = (ResponseData)objs[2];
        if (logger.isDebugEnabled()) {
            logger.debug("No rule for ({}, {}). PLEASE CHECK YOUR CONFIGURATION.", (Object)responseData.getUrl(), (Object)responseData.getMimeType());
        }
    }

    protected void processNoResponseProcessor(Object ... objs) {
        ResponseData responseData = (ResponseData)objs[2];
        if (logger.isDebugEnabled()) {
            logger.debug("No ResponseProcessor for ({}, {}). PLEASE CHECK YOUR CONFIGURATION.", (Object)responseData.getUrl(), (Object)responseData.getMimeType());
        }
    }

    protected void processFinishedThread(Object ... objs) {
    }

    protected void processNoUrlInQueue(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        Integer threadCheckCount = (Integer)objs[2];
        if (logger.isDebugEnabled()) {
            if (urlQueue != null && urlQueue.getUrl() != null) {
                logger.debug("{} is not a target url. ({})", (Object)urlQueue.getUrl(), (Object)threadCheckCount);
            } else {
                logger.debug("The url is null. ({})", (Object)threadCheckCount);
            }
        }
    }

    protected void processCrawlingException(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        Throwable e = (Throwable)objs[2];
        logger.error("Crawling Exception at " + urlQueue.getUrl(), e);
    }

    protected void processCrawlingAccessException(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        CrawlingAccessException e = (CrawlingAccessException)objs[2];
        if (e.isDebugEnabled()) {
            logger.debug("Crawling Access Exception at {}", (Object)urlQueue.getUrl(), (Object)e);
        } else if (e.isInfoEnabled()) {
            logger.info(e.getMessage());
        } else if (e.isWarnEnabled()) {
            logger.warn("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
        } else if (e.isErrorEnabled()) {
            logger.error("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
        }
    }

    protected void processProcessChildUrlByException(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        String url = (String)objs[2];
        Throwable e = (Throwable)objs[3];
        if (logger.isDebugEnabled()) {
            logger.debug("Child URL: {} from {}", new Object[]{url, urlQueue.getUrl(), e});
        }
    }

    protected void processProcessChildUrlsByException(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        Set requestDataSet = (Set)objs[2];
        if (logger.isDebugEnabled()) {
            for (RequestData requestData : requestDataSet) {
                logger.debug("Child URL: {} from {}", (Object)requestData.getUrl(), (Object)urlQueue.getUrl());
            }
        }
    }

    protected void processFinishedCrawling(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isDebugEnabled()) {
            logger.debug("Finished {}", (Object)urlQueue.getUrl());
        }
    }

    protected void processProcessResponse(Object ... objs) {
        ResponseData responseData = (ResponseData)objs[2];
        if (logger.isDebugEnabled()) {
            logger.debug("Processing the response. Http Status: {}, Exec Time: {}", (Object)responseData.getHttpStatusCode(), (Object)responseData.getExecutionTime());
        }
    }

    protected void processRedirectLocation(Object ... objs) {
        ResponseData responseData = (ResponseData)objs[2];
        if (logger.isInfoEnabled()) {
            logger.info("Redirect to URL: {}", (Object)responseData.getRedirectLocation());
        }
    }

    protected void processGetContent(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isDebugEnabled()) {
            logger.debug("Getting the content from URL: {}", (Object)urlQueue.getUrl());
        }
    }

    protected void processNotModified(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isInfoEnabled()) {
            logger.info("Not modified URL: {}", (Object)urlQueue.getUrl());
        }
    }

    protected void processCheckLastModified(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isDebugEnabled()) {
            logger.debug("Checking the last modified: {}", (Object)urlQueue.getLastModified());
        }
    }

    protected void processUnsupportedUrlAtCrawlingStarted(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isInfoEnabled()) {
            logger.info("Unsupported URL: {}", (Object)urlQueue.getUrl());
        }
    }

    protected void processCleanupCrawling(Object ... objs) {
    }

    protected void processStartCrawling(Object ... objs) {
        UrlQueue urlQueue = (UrlQueue)objs[1];
        if (logger.isInfoEnabled()) {
            logger.info("Crawling URL: {}", (Object)urlQueue.getUrl());
        }
    }

    protected void processStartThread(Object ... objs) {
    }
}

