/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codelibs.core.exception.InterruptedRuntimeException;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.ThreadUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.ExecutionTimeoutException;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExtractor
extends AbstractExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExtractor.class);
    protected String outputEncoding = "UTF-8";
    protected String outputExtension = null;
    protected File tempDir = null;
    protected String command;
    protected long executionTimeout = 30000L;
    protected File workingDirectory = null;
    protected String commandOutputEncoding = Charset.defaultCharset().displayName();
    protected int maxOutputLine = 1000;
    protected boolean standardOutput = false;

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        ExtractData extractData;
        String extention;
        String filePrefix;
        String resourceName;
        String string = resourceName = params == null ? null : params.get("resourceName");
        if (StringUtil.isNotBlank((String)resourceName)) {
            String name = this.getFileName(resourceName);
            String[] strings = name.split("\\.");
            StringBuilder buf = new StringBuilder(100);
            if (strings.length > 1) {
                for (int i = 0; i < strings.length - 1; ++i) {
                    if (buf.length() != 0) {
                        buf.append('.');
                    }
                    buf.append(strings[i]);
                }
                filePrefix = buf.toString();
                extention = strings[strings.length - 1];
            } else {
                filePrefix = name;
                extention = "";
            }
            filePrefix = filePrefix.replaceAll("\\p{Zs}", "_");
        } else {
            filePrefix = "none";
            extention = "";
        }
        File inputFile = null;
        File outputFile = null;
        try {
            inputFile = File.createTempFile("cmdextin_" + filePrefix + "_", (String)(StringUtil.isNotBlank((String)extention) ? "." + extention : extention), this.tempDir);
            Object ext = this.outputExtension == null ? (StringUtil.isNotBlank((String)extention) ? "." + extention : extention) : this.outputExtension;
            outputFile = File.createTempFile("cmdextout_" + filePrefix + "_", (String)ext, this.tempDir);
            CopyUtil.copy((InputStream)in, (File)inputFile);
            this.executeCommand(inputFile, outputFile);
            ExtractData extractData2 = new ExtractData(new String(FileUtil.readBytes((File)outputFile), this.outputEncoding));
            if (StringUtil.isNotBlank((String)resourceName)) {
                extractData2.putValues("resourceName", new String[]{resourceName});
            }
            extractData = extractData2;
        }
        catch (IOException e) {
            try {
                throw new ExtractException("Could not extract a content.", e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteInBackground(inputFile);
                FileUtil.deleteInBackground(outputFile);
                throw throwable;
            }
        }
        FileUtil.deleteInBackground((File)inputFile);
        FileUtil.deleteInBackground((File)outputFile);
        return extractData;
    }

    String getFileName(String resourceName) {
        String name = resourceName.replaceAll("/+$", "");
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    private void executeCommand(File inputFile, File outputFile) {
        if (StringUtil.isBlank((String)this.command)) {
            throw new CrawlerSystemException("command is empty.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("$INPUT_FILE", inputFile.getAbsolutePath());
        params.put("$OUTPUT_FILE", outputFile.getAbsolutePath());
        List<String> cmdList = this.parseCommand(this.command, params);
        if (logger.isInfoEnabled()) {
            logger.info("Command: {}", cmdList);
        }
        ProcessBuilder pb = new ProcessBuilder(cmdList);
        if (this.workingDirectory != null) {
            pb.directory(this.workingDirectory);
        }
        if (this.standardOutput) {
            pb.redirectOutput(outputFile);
        } else {
            pb.redirectErrorStream(true);
        }
        Process currentProcess = null;
        MonitorThread mt = null;
        try {
            currentProcess = pb.start();
            mt = new MonitorThread(currentProcess, this.executionTimeout);
            mt.start();
            InputStreamThread it = new InputStreamThread(currentProcess.getInputStream(), this.commandOutputEncoding, this.maxOutputLine);
            it.start();
            currentProcess.waitFor();
            it.join(5000L);
            if (mt.isTeminated()) {
                throw new ExecutionTimeoutException("The command execution is timeout: " + cmdList);
            }
            int exitValue = currentProcess.exitValue();
            if (logger.isInfoEnabled()) {
                if (this.standardOutput) {
                    logger.info("Exit Code: {}", (Object)exitValue);
                } else {
                    logger.info("Exit Code: {} - Process Output:\n{}", (Object)exitValue, (Object)it.getOutput());
                }
            }
            if (exitValue == 143 && mt.isTeminated()) {
                throw new ExecutionTimeoutException("The command execution is timeout: " + cmdList);
            }
        }
        catch (CrawlerSystemException e) {
            throw e;
        }
        catch (InterruptedException e) {
            if (mt != null && mt.isTeminated()) {
                throw new ExecutionTimeoutException("The command execution is timeout: " + cmdList, e);
            }
            throw new InterruptedRuntimeException(e);
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Process terminated.", e);
        }
        finally {
            if (mt != null) {
                mt.setFinished(true);
                try {
                    mt.interrupt();
                }
                catch (Exception exception) {}
            }
            if (currentProcess != null) {
                try {
                    currentProcess.destroy();
                }
                catch (Exception exception) {}
            }
            currentProcess = null;
        }
    }

    List<String> parseCommand(String command, Map<String, String> params) {
        String cmd = command.trim();
        ArrayList<String> cmdList = new ArrayList<String>();
        StringBuilder buf = new StringBuilder(100);
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int prevChar = 32;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if (c == ' ' && !singleQuote && !doubleQuote && buf.length() > 0) {
                cmdList.add(this.getCommandValue(buf.toString(), params));
                buf.delete(0, buf.length());
            } else if (c == '\"' && !singleQuote && prevChar != 92) {
                if (doubleQuote) {
                    if (buf.length() > 0) {
                        cmdList.add(this.getCommandValue(buf.toString(), params));
                        buf.delete(0, buf.length());
                    }
                    doubleQuote = false;
                } else {
                    doubleQuote = true;
                }
            } else if (c == '\'' && !doubleQuote && prevChar != 92) {
                if (singleQuote) {
                    if (buf.length() > 0) {
                        cmdList.add(this.getCommandValue(buf.toString(), params));
                        buf.delete(0, buf.length());
                    }
                    singleQuote = false;
                } else {
                    singleQuote = true;
                }
            } else {
                buf.append(c);
            }
            prevChar = c;
        }
        if (buf.length() > 0) {
            cmdList.add(this.getCommandValue(buf.toString(), params));
        }
        return cmdList;
    }

    private String getCommandValue(String key, Map<String, String> params) {
        String value = params.get(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setOutputExtension(String outputExtension) {
        this.outputExtension = outputExtension;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setCommandOutputEncoding(String commandOutputEncoding) {
        this.commandOutputEncoding = commandOutputEncoding;
    }

    public void setMaxOutputLine(int maxOutputLine) {
        this.maxOutputLine = maxOutputLine;
    }

    public void setStandardOutput(boolean standardOutput) {
        this.standardOutput = standardOutput;
    }

    protected static class MonitorThread
    extends Thread {
        private final Process process;
        private final long timeout;
        private boolean finished = false;
        private boolean teminated = false;

        public MonitorThread(Process process, long timeout) {
            this.process = process;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            block3: {
                ThreadUtil.sleepQuietly((long)this.timeout);
                if (!this.finished) {
                    try {
                        this.process.destroy();
                        this.teminated = true;
                    }
                    catch (Exception e) {
                        if (!logger.isInfoEnabled()) break block3;
                        logger.info("Could not kill the subprocess.", (Throwable)e);
                    }
                }
            }
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isTeminated() {
            return this.teminated;
        }
    }

    protected static class InputStreamThread
    extends Thread {
        private BufferedReader br;
        private final List<String> list = new LinkedList<String>();
        private final int maxLineBuffer;

        public InputStreamThread(InputStream is, String charset, int maxOutputLineBuffer) {
            try {
                this.br = new BufferedReader(new InputStreamReader(is, charset));
            }
            catch (UnsupportedEncodingException e) {
                this.br = new BufferedReader(new InputStreamReader(is, Constants.UTF_8_CHARSET));
            }
            this.maxLineBuffer = maxOutputLineBuffer;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(line);
                    }
                    this.list.add(line);
                    if (this.list.size() <= this.maxLineBuffer) continue;
                    this.list.remove(0);
                }
            }
            catch (IOException e) {
                throw new CrawlerSystemException(e);
            }
        }

        public String getOutput() {
            StringBuilder buf = new StringBuilder(100);
            for (String value : this.list) {
                buf.append(value).append("\n");
            }
            return buf.toString();
        }
    }
}

