/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.storage;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.Item;
import io.minio.messages.Tags;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(StorageClient.class);
    protected String charset = "UTF-8";
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected AtomicBoolean isInit = new AtomicBoolean(false);
    protected MinioClient minioClient;

    @Override
    public void init() {
        super.init();
        MinioClient.Builder builder = MinioClient.builder();
        String endpoint = this.getInitParameter("endpoint", null, String.class);
        if (StringUtil.isBlank((String)endpoint)) {
            throw new CrawlingAccessException("endpoint is blank.");
        }
        builder.endpoint(endpoint);
        String accessKey = this.getInitParameter("accessKey", null, String.class);
        if (StringUtil.isBlank((String)accessKey)) {
            throw new CrawlingAccessException("accessKey is blank.");
        }
        String secretKey = this.getInitParameter("secretKey", null, String.class);
        if (StringUtil.isBlank((String)secretKey)) {
            throw new CrawlingAccessException("secretKey is blank.");
        }
        builder.credentials(accessKey, secretKey);
        try {
            this.minioClient = builder.build();
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Failed to create MinioClient(" + endpoint + ")", e);
        }
        this.minioClient.setTimeout(this.getInitParameter("connectTimeout", 10000L, Long.class).longValue(), this.getInitParameter("writeTimeout", 10000L, Long.class).longValue(), this.getInitParameter("readTimeout", 10000L, Long.class).longValue());
    }

    protected boolean bucketExists(String name) {
        try {
            BucketExistsArgs args = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(name)).build();
            return this.minioClient.bucketExists(args);
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Could not access bucket:" + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (!this.isInit.get()) {
            AtomicBoolean atomicBoolean = this.isInit;
            synchronized (atomicBoolean) {
                if (!this.isInit.get()) {
                    this.init();
                    this.isInit.set(true);
                }
            }
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (accessTimeoutTarget != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected String[] parsePath(String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            String[] values = path.split("/", 2);
            if (values.length == 2) {
                return values;
            }
            if (values.length == 1 && StringUtil.isNotEmpty((String)values[0])) {
                return new String[]{values[0], ""};
            }
        }
        throw new CrawlingAccessException("Invalid path: " + path);
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block27: {
            responseData = new ResponseData();
            try {
                responseData.setMethod(includeContent ? "GET" : "HEAD");
                String filePath = this.preprocessUri(uri);
                responseData.setUrl(filePath);
                String[] paths = this.parsePath(filePath.replaceFirst("^storage:/+", ""));
                String bucketName = paths[0];
                String path = paths[1];
                StatObjectResponse statObject = this.getStatObject(bucketName, path);
                if (statObject == null) {
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                    ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(path).recursive(false).includeUserMetadata(false).useApiVersion1(false).build();
                    for (Result result : this.minioClient.listObjects(args)) {
                        Item item = (Item)result.get();
                        String objectName = item.objectName();
                        requestDataSet.add(RequestDataBuilder.newRequestData().get().url("storage://" + bucketName + "/" + objectName).build());
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData");
                }
                responseData.setContentLength(statObject.size());
                this.checkMaxContentLength(responseData);
                responseData.setHttpStatusCode(200);
                responseData.setCharSet(this.getCharset());
                responseData.setLastModified(statObject.lastModified() == null ? null : Date.from(statObject.lastModified().toInstant()));
                responseData.setMimeType(statObject.contentType());
                statObject.headers().forEach(e -> responseData.addMetaData((String)e.getFirst(), e.getSecond()));
                if (this.contentLengthHelper != null) {
                    long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                    if (responseData.getContentLength() > maxLength) {
                        throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                    }
                }
                if (!includeContent) break block27;
                Tags objectTags = this.getObjectTags(bucketName, path);
                if (objectTags != null) {
                    objectTags.get().entrySet().forEach(e -> responseData.addMetaData((String)e.getKey(), e.getValue()));
                }
                if (statObject.size() < this.maxCachedContentSize) {
                    GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(path)).build();
                    try (BufferedInputStream contentStream = new BufferedInputStream((InputStream)this.minioClient.getObject(args));){
                        responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)contentStream));
                    }
                    catch (Exception e2) {
                        logger.warn("I/O Exception.", (Throwable)e2);
                        responseData.setHttpStatusCode(500);
                    }
                } else {
                    File outputFile = null;
                    try {
                        outputFile = File.createTempFile("crawler-SmbClient-", ".out");
                        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(path)).build();
                        CopyUtil.copy((InputStream)this.minioClient.getObject(args), (File)outputFile);
                        responseData.setResponseBody(outputFile, true);
                    }
                    catch (Exception e3) {
                        logger.warn("I/O Exception.", (Throwable)e3);
                        responseData.setHttpStatusCode(500);
                        FileUtil.deleteInBackground((File)outputFile);
                    }
                }
                MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                try (InputStream is = responseData.getResponseBody();){
                    responseData.setMimeType(mimeTypeHelper.getContentType(is, statObject.object()));
                }
                catch (Exception e4) {
                    responseData.setMimeType(mimeTypeHelper.getContentType(null, statObject.object()));
                }
            }
            catch (CrawlerSystemException e5) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw e5;
            }
            catch (Exception e6) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw new CrawlingAccessException("Could not access " + uri, e6);
            }
        }
        return responseData;
    }

    protected StatObjectResponse getStatObject(String bucketName, String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        try {
            StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(path)).build();
            return this.minioClient.statObject(args);
        }
        catch (ErrorResponseException e) {
            String code;
            switch (code = e.errorResponse().code()) {
                case "NoSuchBucket": {
                    throw new CrawlingAccessException("Bucket " + bucketName + " is not found.", e);
                }
                case "NoSuchKey": 
                case "NoSuchObject": {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} is not an object.", (Object)path);
                        break;
                    }
                }
                default: {
                    logger.warn(path + " is not an object.", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn(path + " is not an object.", (Throwable)e);
        }
        return null;
    }

    protected Tags getObjectTags(String bucketName, String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        try {
            GetObjectTagsArgs args = (GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketName)).object(path)).build();
            return this.minioClient.getObjectTags(args);
        }
        catch (ErrorResponseException e) {
            String code;
            switch (code = e.errorResponse().code()) {
                case "NoSuchBucket": {
                    throw new CrawlingAccessException("Bucket " + bucketName + " is not found.", e);
                }
                case "NoSuchKey": 
                case "NoSuchObject": {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} is not an object.", (Object)path);
                        break;
                    }
                }
                default: {
                    logger.warn(path + " is not an object.", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn(path + " is not an object.", (Throwable)e);
        }
        return null;
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new CrawlerSystemException("The uri is empty.");
        }
        Object filePath = uri;
        if (!((String)filePath).startsWith("storage:")) {
            filePath = "storage://" + (String)filePath;
        }
        return filePath;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }
}

