/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.smb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.SID;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.internal.dtyp.ACE;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.smb.SmbAuthentication;
import org.codelibs.fess.crawler.client.smb.SmbAuthenticationHolder;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(SmbClient.class);
    public static final String SMB_AUTHENTICATIONS_PROPERTY = "smbAuthentications";
    public static final String SMB_ALLOWED_SID_ENTRIES = "smbAllowedSidEntries";
    public static final String SMB_DENIED_SID_ENTRIES = "smbDeniedSidEntries";
    public static final String SMB_CREATE_TIME = "smbCreateTime";
    public static final String SMB_OWNER_ATTRIBUTES = "smbOwnerAttributes";
    protected String charset = "UTF-8";
    protected boolean resolveSids = true;
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected volatile SmbAuthenticationHolder smbAuthenticationHolder;
    protected CIFSContext cifsContext;

    @Override
    public synchronized void init() {
        if (this.smbAuthenticationHolder != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing SmbClient...");
        }
        super.init();
        Properties props = new Properties();
        System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith("jcifs.")).forEach(e -> props.setProperty((String)e.getKey(), (String)e.getValue()));
        try {
            this.cifsContext = new BaseContext((Configuration)new PropertyConfiguration(props));
        }
        catch (CIFSException e2) {
            throw new CrawlingAccessException(e2);
        }
        SmbAuthenticationHolder holder = new SmbAuthenticationHolder();
        SmbAuthentication[] smbAuthentications = this.getInitParameter(SMB_AUTHENTICATIONS_PROPERTY, new SmbAuthentication[0], SmbAuthentication[].class);
        if (smbAuthentications != null) {
            for (SmbAuthentication smbAuthentication : smbAuthentications) {
                holder.add(smbAuthentication);
            }
        }
        this.smbAuthenticationHolder = holder;
    }

    @Override
    public void close() throws Exception {
        this.smbAuthenticationHolder = null;
        if (this.cifsContext != null) {
            this.cifsContext.close();
        }
    }

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (this.smbAuthenticationHolder == null) {
            this.init();
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (accessTimeoutTarget != null) {
                accessTimeoutTarget.stop();
                if (accessTimeoutTask != null && !accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected NtlmPasswordAuthenticator getAuthenticator(SmbAuthentication smbAuthentication) {
        return new NtlmPasswordAuthenticator(smbAuthentication.getDomain() == null ? "" : smbAuthentication.getDomain(), smbAuthentication.getUsername(), smbAuthentication.getPassword());
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block55: {
            responseData = new ResponseData();
            responseData.setMethod("GET");
            String filePath = this.preprocessUri(uri);
            responseData.setUrl(filePath);
            SmbFile file = null;
            SmbAuthentication smbAuthentication = this.smbAuthenticationHolder.get(filePath);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating SmbFile: {}", (Object)filePath);
            }
            try {
                file = smbAuthentication == null ? new SmbFile(filePath, this.cifsContext) : new SmbFile(filePath, this.cifsContext.withCredentials((Credentials)this.getAuthenticator(smbAuthentication)));
            }
            catch (MalformedURLException e) {
                logger.warn("Could not parse url: " + filePath, (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Processing SmbFile: {}", (Object)filePath);
            }
            try {
                if (file == null) {
                    responseData.setHttpStatusCode(404);
                    responseData.setCharSet(this.charset);
                    responseData.setContentLength(0L);
                    break block55;
                }
                if (file.isFile()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Checking SmbFile Size: {}", (Object)filePath);
                    }
                    responseData.setContentLength(file.length());
                    this.checkMaxContentLength(responseData);
                    responseData.setHttpStatusCode(200);
                    responseData.setCharSet(this.geCharSet(file));
                    responseData.setLastModified(new Date(file.lastModified()));
                    responseData.addMetaData(SMB_CREATE_TIME, new Date(file.createTime()));
                    try {
                        jcifs.smb.SID ownerUser;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Parsing SmbFile Owner: {}", (Object)filePath);
                        }
                        if ((ownerUser = file.getOwnerUser()) != null) {
                            String[] ownerAttributes = new String[]{ownerUser.getAccountName(), ownerUser.getDomainName()};
                            responseData.addMetaData(SMB_OWNER_ATTRIBUTES, ownerAttributes);
                        }
                    }
                    catch (IOException e) {
                        throw new CrawlingAccessException("Cannot get owner of the file: " + filePath, e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsing SmbFile ACL: {}", (Object)filePath);
                    }
                    this.processAccessControlEntries(responseData, file);
                    Map headerFieldMap = file.getHeaderFields();
                    if (headerFieldMap != null) {
                        for (Map.Entry entry : headerFieldMap.entrySet()) {
                            responseData.addMetaData((String)entry.getKey(), entry.getValue());
                        }
                    }
                    if (file.canRead()) {
                        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                        if (includeContent) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Parsing SmbFile Content: {}", (Object)filePath);
                            }
                            if (file.getContentLengthLong() < this.maxCachedContentSize) {
                                try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)new SmbFileInputStream(file));){
                                    responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)bufferedInputStream));
                                }
                                catch (Exception exception) {
                                    logger.warn("I/O Exception.", (Throwable)exception);
                                    responseData.setHttpStatusCode(500);
                                }
                            } else {
                                File file2 = null;
                                try {
                                    File file3 = File.createTempFile("crawler-SmbClient-", ".out");
                                    this.copy(file, file3);
                                    responseData.setResponseBody(file3, true);
                                }
                                catch (Exception e) {
                                    logger.warn("I/O Exception.", (Throwable)e);
                                    responseData.setHttpStatusCode(500);
                                    FileUtil.deleteInBackground(file2);
                                }
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Parsing SmbFile MIME Type: {}", (Object)filePath);
                            }
                            try (InputStream inputStream = responseData.getResponseBody();){
                                responseData.setMimeType(mimeTypeHelper.getContentType(inputStream, file.getName()));
                            }
                            catch (Exception exception) {
                                responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Parsing SmbFile MIME Type: {}", (Object)filePath);
                            }
                            try (SmbFileInputStream smbFileInputStream = new SmbFileInputStream(file);){
                                responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)smbFileInputStream, file.getName()));
                            }
                            catch (Exception exception) {
                                responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                            }
                        }
                        if (this.contentLengthHelper != null) {
                            long l = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                            if (responseData.getContentLength() > l) {
                                throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + l + " byte. The url is " + filePath);
                            }
                        }
                        break block55;
                    }
                    responseData.setHttpStatusCode(403);
                    responseData.setMimeType("application/octet-stream");
                    break block55;
                }
                if (file.isDirectory()) {
                    SmbFile[] files;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsing SmbFile Directory: {}", (Object)filePath);
                    }
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>(100);
                    if (includeContent && (files = file.listFiles()) != null) {
                        for (SmbFile f : files) {
                            String chileUri = f.toString();
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData");
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            catch (CrawlerSystemException e) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw e;
            }
            catch (SmbException e) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw new CrawlingAccessException("Could not access " + uri, e);
            }
        }
        return responseData;
    }

    protected void processAccessControlEntries(ResponseData responseData, SmbFile file) {
        try {
            ACE[] aces = file.getSecurity(this.resolveSids);
            if (aces != null) {
                HashSet<SID> sidAllowSet = new HashSet<SID>();
                HashSet sidDenySet = new HashSet();
                for (ACE ace : aces) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("ACE:{}", (Object)ace);
                    }
                    this.processAllowedSIDs(file, ace.getSID(), ace.isAllow() ? sidAllowSet : sidDenySet);
                }
                responseData.addMetaData(SMB_ALLOWED_SID_ENTRIES, sidAllowSet.toArray(new SID[sidAllowSet.size()]));
                responseData.addMetaData(SMB_DENIED_SID_ENTRIES, sidDenySet.toArray(new SID[sidDenySet.size()]));
            }
        }
        catch (IOException e) {
            throw new CrawlingAccessException("Could not access " + file.getPath(), e);
        }
    }

    protected void processAllowedSIDs(SmbFile file, SID sid, Set<SID> sidSet) {
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug("SID:{}", (Object)sid);
            }
            int type = sid.getType();
            sidSet.add(sid);
            if (type == 2 || type == 4) {
                try {
                    SID[] children;
                    CIFSContext context = file.getContext();
                    for (SID child : children = context.getSIDResolver().getGroupMemberSids(context, file.getServer(), sid.getDomainSid(), sid.getRid(), 1)) {
                        if (sidSet.contains(child)) continue;
                        this.processAllowedSIDs(file, child, sidSet);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Exception on SID processing.", (Throwable)e);
                }
            }
        }
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new CrawlerSystemException("The uri is empty.");
        }
        return uri;
    }

    protected String geCharSet(SmbFile file) {
        return this.charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }

    private void copy(SmbFile src, File dest) {
        if (dest.exists() && !dest.canWrite()) {
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream((InputStream)new SmbFileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            int length;
            byte[] buf = new byte[1024];
            while (-1 < (length = in.read(buf))) {
                out.write(buf, 0, length);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public boolean isResolveSids() {
        return this.resolveSids;
    }

    public void setResolveSids(boolean resolveSids) {
        this.resolveSids = resolveSids;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSmbAuthenticationHolder(SmbAuthenticationHolder smbAuthenticationHolder) {
        this.smbAuthenticationHolder = smbAuthenticationHolder;
    }
}

