/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http.form;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.Pair;
import org.codelibs.core.stream.StreamUtil;
import org.codelibs.fess.crawler.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormScheme
implements AuthScheme {
    private static final Logger logger = LoggerFactory.getLogger(FormScheme.class);
    private static final String ENCODING = "encoding";
    private static final String TOKEN_URL = "token_url";
    private static final String TOKEN_PATTERN = "token_pattern";
    private static final String TOKEN_NAME = "token_name";
    private static final String TOKEN_METHOD = "token_method";
    private static final String TOKEN_PARAMTERS = "token_paramters";
    private static final String LOGIN_METHOD = "login_method";
    private static final String LOGIN_URL = "login_url";
    private static final String LOGIN_PARAMETERS = "login_parameters";
    private static final String PASSWORD = "${password}";
    private static final String USERNAME = "${username}";
    private final Map<String, String> parameterMap;

    public FormScheme(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
    }

    public String getSchemeName() {
        return "form";
    }

    public String getParameter(String name) {
        return this.parameterMap.get(name);
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return null;
    }

    public void authenticate(Credentials credentials, BiConsumer<HttpUriRequest, BiConsumer<HttpResponse, HttpEntity>> executor) {
        HttpPost httpRequest;
        String tokenUrl = this.getParameter(TOKEN_URL);
        String tokenPattern = this.getParameter(TOKEN_PATTERN);
        ArrayList<Pair<String, String>> responseParams = new ArrayList<Pair<String, String>>();
        String encoding = this.getParameter(ENCODING);
        if (StringUtil.isNotBlank((String)tokenUrl) && StringUtil.isNotBlank((String)tokenPattern)) {
            HttpPost httpRequest2;
            String tokenHttpMethod = this.getParameter(TOKEN_METHOD);
            String tokenReqParams = this.getParameter(TOKEN_PARAMTERS);
            if ("POST".equalsIgnoreCase(tokenHttpMethod)) {
                HttpPost httpPost = new HttpPost(tokenUrl);
                if (StringUtil.isNotBlank((String)tokenReqParams)) {
                    HttpEntity httpEntity = this.parseRequestParameters(tokenReqParams, null, encoding);
                    httpPost.setEntity(httpEntity);
                }
                httpRequest2 = httpPost;
            } else {
                StringBuilder buf = new StringBuilder(100);
                buf.append(tokenUrl);
                if (StringUtil.isNotBlank((String)tokenReqParams)) {
                    if (tokenUrl.indexOf(63) >= 0) {
                        buf.append('&');
                    } else {
                        buf.append('?');
                    }
                    buf.append(tokenReqParams);
                }
                httpRequest2 = new HttpGet(buf.toString());
            }
            executor.accept((HttpUriRequest)httpRequest2, (response, entity) -> {
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode < 400 || httpStatusCode == 401) {
                    this.parseTokenPage(tokenPattern, (List<Pair<String, String>>)responseParams, (HttpEntity)entity);
                } else {
                    String content;
                    try {
                        content = new String(InputStreamUtil.getBytes((InputStream)entity.getContent()), Constants.UTF_8_CHARSET);
                    }
                    catch (IOException e) {
                        content = e.getMessage();
                    }
                    logger.warn("Failed to access to {}. The http status is {}.\n{}", new Object[]{tokenUrl, httpStatusCode, content});
                }
            });
        }
        String loginHttpMethod = this.getParameter(LOGIN_METHOD);
        String originalLoginUrl = this.getParameter(LOGIN_URL);
        String loginUrl = this.replaceCredentials(credentials, originalLoginUrl);
        String loginReqParams = this.replaceCredentials(credentials, this.getParameter(LOGIN_PARAMETERS));
        if (StringUtil.isBlank((String)loginUrl)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No login.url");
            }
            return;
        }
        if ("POST".equalsIgnoreCase(loginHttpMethod)) {
            HttpPost httpPost = new HttpPost(loginUrl);
            if (loginReqParams.length() > 0) {
                httpPost.setEntity(this.parseRequestParameters(loginReqParams.toString(), responseParams, encoding));
            }
            httpRequest = httpPost;
        } else {
            StringBuilder buf = new StringBuilder(100);
            buf.append(loginUrl);
            if (loginReqParams.length() > 0) {
                if (loginUrl.indexOf(63) >= 0) {
                    buf.append('&');
                } else {
                    buf.append('?');
                }
                buf.append(loginReqParams);
                if (!responseParams.isEmpty()) {
                    buf.append('&');
                    responseParams.stream().forEach(p -> {
                        try {
                            buf.append(URLEncoder.encode((String)p.getFirst(), encoding));
                            buf.append('=');
                            buf.append(URLEncoder.encode((String)p.getSecond(), encoding));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IORuntimeException((IOException)e);
                        }
                    });
                }
            }
            httpRequest = new HttpGet(buf.toString());
        }
        executor.accept((HttpUriRequest)httpRequest, (response, entity) -> {
            int httpStatusCode = response.getStatusLine().getStatusCode();
            if (httpStatusCode >= 400) {
                String content;
                try {
                    content = new String(InputStreamUtil.getBytes((InputStream)entity.getContent()), Constants.UTF_8_CHARSET);
                }
                catch (IOException e) {
                    content = e.getMessage();
                }
                logger.warn("Failed to login on {}. The http status is {}.\n{}", new Object[]{originalLoginUrl, httpStatusCode, content});
            } else if (logger.isDebugEnabled()) {
                logger.debug("Logged in {}", (Object)originalLoginUrl);
            }
        });
    }

    protected void parseTokenPage(String tokenPattern, List<Pair<String, String>> responseParams, HttpEntity entity) {
        try {
            String tokenName = this.getParameter(TOKEN_NAME);
            String content = new String(InputStreamUtil.getBytes((InputStream)entity.getContent()), Constants.UTF_8_CHARSET);
            String tokenValue = this.getTokenValue(tokenPattern, content);
            if (StringUtil.isNotBlank((String)tokenValue)) {
                responseParams.add((Pair<String, String>)new Pair((Object)tokenName, (Object)tokenValue));
                if (logger.isDebugEnabled()) {
                    logger.debug("Token: {}", (Object)tokenValue);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Token is not found.\n{}", (Object)content);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected HttpEntity parseRequestParameters(String params, List<Pair<String, String>> paramList, String encoding) {
        try {
            List parameters = (List)StreamUtil.split((String)params, (String)"&").get(stream -> stream.filter(StringUtil::isNotBlank).map(s -> {
                String value;
                String name;
                int pos = s.indexOf(61);
                if (pos == -1 || pos == s.length() - 1) {
                    name = s;
                    value = "";
                } else {
                    name = s.substring(0, pos);
                    value = s.substring(pos + 1);
                }
                return new BasicNameValuePair(name, value);
            }).collect(Collectors.toList()));
            if (paramList != null) {
                parameters.addAll(paramList.stream().map(p -> new BasicNameValuePair((String)p.getFirst(), (String)p.getSecond())).collect(Collectors.toList()));
            }
            return new UrlEncodedFormEntity(parameters, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException((IOException)e);
        }
    }

    protected String getTokenValue(String tokenPattern, String content) {
        Matcher matcher = Pattern.compile(tokenPattern).matcher(content);
        if (matcher.find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Matched: {}", (Object)matcher.group());
            }
            if (matcher.groupCount() > 0) {
                return matcher.group(1);
            }
        }
        return null;
    }

    protected String replaceCredentials(Credentials credentials, String value) {
        if (StringUtil.isNotBlank((String)value)) {
            return value.replace(USERNAME, credentials.getUserPrincipal().getName()).replace(PASSWORD, credentials.getPassword());
        }
        return "";
    }

    public String toString() {
        return "FormScheme [parameterMap=" + this.parameterMap + "]";
    }
}

