/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.Pair;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.http.Authentication;
import org.codelibs.fess.crawler.client.http.HcConnectionMonitorTarget;
import org.codelibs.fess.crawler.client.http.RequestHeader;
import org.codelibs.fess.crawler.client.http.conn.IdnDnsResolver;
import org.codelibs.fess.crawler.client.http.form.FormScheme;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.RobotsTxt;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.codelibs.fess.crawler.helper.RobotsTxtHelper;
import org.codelibs.fess.crawler.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcHttpClient
extends AbstractCrawlerClient {
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_AUTH_SCHEME_PROPERTY = "proxyAuthScheme";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String ROBOTS_TXT_ENABLED_PROPERTY = "robotsTxtEnabled";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    public static final String REQUERT_HEADERS_PROPERTY = "requestHeaders";
    public static final String REDIRECTS_ENABLED = "redirectsEnabled";
    public static final String COOKIES_PROPERTY = "cookies";
    public static final String AUTH_SCHEME_PROVIDERS_PROPERTY = "authSchemeProviders";
    public static final String IGNORE_SSL_CERTIFICATE_PROPERTY = "ignoreSslCertificate";
    public static final String DEFAULT_MAX_CONNECTION_PER_ROUTE_PROPERTY = "defaultMaxConnectionPerRoute";
    public static final String MAX_TOTAL_CONNECTION_PROPERTY = "maxTotalConnection";
    public static final String TIME_TO_LIVE_TIME_UNIT_PROPERTY = "timeToLiveTimeUnit";
    public static final String TIME_TO_LIVE_PROPERTY = "timeToLive";
    private static final Logger logger = LoggerFactory.getLogger(HcHttpClient.class);
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    @Resource
    protected MimeTypeHelper mimeTypeHelper;
    protected volatile CloseableHttpClient httpClient;
    private final List<Header> requestHeaderList = new ArrayList<Header>();
    private final Map<String, Object> httpClientPropertyMap = new HashMap<String, Object>();
    private TimeoutTask connectionMonitorTask;
    protected Integer connectionTimeout;
    protected Integer maxTotalConnections;
    protected Integer maxConnectionsPerRoute;
    protected Integer soTimeout;
    protected String cookieSpec;
    protected String userAgent = "Crawler";
    protected HttpClientContext httpClientContext = HttpClientContext.create();
    protected String proxyHost;
    protected Integer proxyPort;
    protected AuthScheme proxyAuthScheme = new BasicScheme();
    protected Credentials proxyCredentials;
    protected String defaultMimeType = "application/octet-stream";
    protected CookieStore cookieStore = new BasicCookieStore();
    protected HttpClientConnectionManager clientConnectionManager;
    protected DnsResolver dnsResolver = new IdnDnsResolver();
    protected Map<String, AuthSchemeProvider> authSchemeProviderMap;
    protected int connectionCheckInterval = 5;
    protected long idleConnectionTimeout = 60000L;
    protected Pattern redirectHttpStatusPattern = Pattern.compile("[3][0-9][0-9]");
    protected boolean useRobotsTxtDisallows = true;
    protected boolean useRobotsTxtAllows = true;
    protected CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    protected AuthCache authCache = new BasicAuthCache();
    protected HttpRoutePlanner routePlanner;
    protected boolean redirectsEnabled = false;
    protected Lookup<CookieSpecProvider> cookieSpecRegistry;
    protected String[] cookieDatePatterns = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", ""};
    protected LayeredConnectionSocketFactory sslSocketFactory;

    @Override
    public synchronized void init() {
        Lookup<CookieSpecProvider> cookieSpecRegistry;
        RequestHeader[] requestHeaders;
        HttpRoutePlanner planner;
        Integer soTimeoutParam;
        if (this.httpClient != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing {}", (Object)HcHttpClient.class.getName());
        }
        super.init();
        Boolean robotsTxtEnabled = this.getInitParameter(ROBOTS_TXT_ENABLED_PROPERTY, Boolean.TRUE, Boolean.class);
        if (this.robotsTxtHelper != null) {
            this.robotsTxtHelper.setEnabled(robotsTxtEnabled);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Integer connectionTimeoutParam = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout, Integer.class);
        if (connectionTimeoutParam != null) {
            requestConfigBuilder.setConnectTimeout(connectionTimeoutParam.intValue());
        }
        if ((soTimeoutParam = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout, Integer.class)) != null) {
            requestConfigBuilder.setSocketTimeout(soTimeoutParam.intValue());
        }
        RegistryBuilder authSchemeProviderBuilder = RegistryBuilder.create();
        Map factoryMap = this.getInitParameter(AUTH_SCHEME_PROVIDERS_PROPERTY, this.authSchemeProviderMap, Map.class);
        if (factoryMap != null) {
            for (Map.Entry entry : factoryMap.entrySet()) {
                authSchemeProviderBuilder.register((String)entry.getKey(), (Object)((AuthSchemeProvider)entry.getValue()));
            }
        }
        this.userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent, String.class);
        if (StringUtil.isNotBlank((String)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        if ((planner = this.buildRoutePlanner()) != null) {
            httpClientBuilder.setRoutePlanner(planner);
        }
        Authentication[] siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new Authentication[0], Authentication[].class);
        ArrayList<Pair> formSchemeList = new ArrayList<Pair>();
        for (Authentication authentication : siteCredentialList) {
            AuthScheme authScheme = authentication.getAuthScheme();
            if (authScheme instanceof FormScheme) {
                formSchemeList.add(new Pair((Object)((FormScheme)authScheme), (Object)authentication.getCredentials()));
                continue;
            }
            AuthScope authScope = authentication.getAuthScope();
            this.credentialsProvider.setCredentials(authScope, authentication.getCredentials());
            if (authScope.getHost() == null || authScheme == null) continue;
            HttpHost targetHost = new HttpHost(authScope.getHost(), authScope.getPort());
            this.authCache.put(targetHost, authScheme);
        }
        this.httpClientContext.setAuthCache(this.authCache);
        this.httpClientContext.setCredentialsProvider(this.credentialsProvider);
        for (RequestHeader requestHeader : requestHeaders = this.getInitParameter(REQUERT_HEADERS_PROPERTY, new RequestHeader[0], RequestHeader[].class)) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
        }
        requestConfigBuilder.setRedirectsEnabled(this.getInitParameter(REDIRECTS_ENABLED, this.redirectsEnabled, Boolean.class).booleanValue());
        if (this.cookieSpec != null) {
            requestConfigBuilder.setCookieSpec(this.cookieSpec);
        }
        httpClientBuilder.setDefaultCookieStore(this.cookieStore);
        if (this.cookieStore != null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = this.getInitParameter(COOKIES_PROPERTY, new Cookie[0], Cookie[].class)) {
                this.cookieStore.addCookie(cookie);
            }
        }
        if ((cookieSpecRegistry = this.buildCookieSpecRegistry()) != null) {
            httpClientBuilder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        }
        this.clientConnectionManager = this.buildConnectionManager(httpClientBuilder);
        this.connectionMonitorTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)new HcConnectionMonitorTarget(this.clientConnectionManager, this.idleConnectionTimeout), this.connectionCheckInterval, true);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setDnsResolver(this.dnsResolver).setConnectionManager(this.clientConnectionManager).setDefaultRequestConfig(requestConfigBuilder.build()).build();
        if (!this.httpClientPropertyMap.isEmpty()) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(closeableHttpClient.getClass());
            for (Map.Entry<String, Object> entry : this.httpClientPropertyMap.entrySet()) {
                String propertyName = entry.getKey();
                if (beanDesc.hasPropertyDesc(propertyName)) {
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
                    propertyDesc.setValue((Object)closeableHttpClient, entry.getValue());
                    continue;
                }
                logger.warn("DefaultHttpClient does not have {}.", (Object)propertyName);
            }
        }
        formSchemeList.forEach(p -> {
            FormScheme scheme = (FormScheme)p.getFirst();
            Credentials credentials = (Credentials)p.getSecond();
            scheme.authenticate(credentials, (request, consumer) -> {
                for (Header header : this.requestHeaderList) {
                    request.addHeader(header);
                }
                HttpEntity httpEntity = null;
                try {
                    CloseableHttpResponse response = closeableHttpClient.execute(request, (HttpContext)new BasicHttpContext((HttpContext)this.httpClientContext));
                    httpEntity = response.getEntity();
                    consumer.accept(response, httpEntity);
                }
                catch (Exception e) {
                    try {
                        request.abort();
                        logger.warn("Failed to authenticate on " + scheme, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        EntityUtils.consumeQuietly(httpEntity);
                        throw throwable;
                    }
                    EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                }
                EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            });
        });
        this.httpClient = closeableHttpClient;
    }

    protected HttpClientConnectionManager buildConnectionManager(HttpClientBuilder httpClientBuilder) {
        LayeredConnectionSocketFactory sslSocketFactory = this.buildSSLSocketFactory(httpClientBuilder);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        long timeToLive = this.getInitParameter(TIME_TO_LIVE_PROPERTY, 5L, Long.class);
        TimeUnit timeUnit = TimeUnit.valueOf(this.getInitParameter(TIME_TO_LIVE_TIME_UNIT_PROPERTY, "MINUTES", String.class));
        int maxTotal = this.getInitParameter(MAX_TOTAL_CONNECTION_PROPERTY, 200, Integer.class);
        int defaultMaxPerRoute = this.getInitParameter(DEFAULT_MAX_CONNECTION_PER_ROUTE_PROPERTY, 20, Integer.class);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, this.dnsResolver, timeToLive, timeUnit);
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        return connectionManager;
    }

    protected LayeredConnectionSocketFactory buildSSLSocketFactory(HttpClientBuilder httpClientBuilder) {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        if (this.getInitParameter(IGNORE_SSL_CERTIFICATE_PROPERTY, false, Boolean.class).booleanValue()) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
                httpClientBuilder.setSSLContext(sslContext);
                return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (Exception e) {
                logger.warn("Failed to create TrustSelfSignedStrategy.", (Throwable)e);
            }
        }
        return SSLConnectionSocketFactory.getSocketFactory();
    }

    protected Lookup<CookieSpecProvider> buildCookieSpecRegistry() {
        if (this.cookieSpecRegistry != null) {
            return this.cookieSpecRegistry;
        }
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, this.cookieDatePatterns, false);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        return RegistryBuilder.create().register("default", (Object)defaultProvider).register("best-match", (Object)defaultProvider).register("compatibility", (Object)defaultProvider).register("standard", (Object)laxStandardProvider).register("standard-strict", (Object)strictStandardProvider).register("netscape", (Object)new NetscapeDraftSpecProvider()).register("ignoreCookies", (Object)new IgnoreSpecProvider()).build();
    }

    @Override
    public void close() {
        if (this.httpClient == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Closing HcHttpClient...");
        }
        if (this.connectionMonitorTask != null) {
            this.connectionMonitorTask.cancel();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpClient.", (Throwable)e);
            }
            this.httpClient = null;
            if (this.clientConnectionManager != null) {
                this.clientConnectionManager.shutdown();
            }
        }
    }

    public void addHttpClientProperty(String name, Object value) {
        if (StringUtil.isNotBlank((String)name) && value != null) {
            this.httpClientPropertyMap.put(name, value);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRobotsTxt(String url) {
        HttpEntity httpEntity;
        block18: {
            if (StringUtil.isBlank((String)url)) {
                throw new CrawlerSystemException("url is null or empty.");
            }
            if (this.robotsTxtHelper == null) return;
            if (!this.robotsTxtHelper.isEnabled()) {
                return;
            }
            CrawlerContext crawlerContext = CrawlingParameterUtil.getCrawlerContext();
            if (crawlerContext == null) {
                return;
            }
            int idx = url.indexOf(47, url.indexOf("://") + 3);
            String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
            String robotTxtUrl = hostUrl + "/robots.txt";
            if (crawlerContext.getRobotsTxtUrlSet().contains(robotTxtUrl)) {
                if (!logger.isDebugEnabled()) return;
                logger.debug("{} is already visited.", (Object)robotTxtUrl);
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Checking URL: {}", (Object)robotTxtUrl);
            }
            crawlerContext.getRobotsTxtUrlSet().add(robotTxtUrl);
            HttpGet httpGet = new HttpGet(robotTxtUrl);
            for (Header header : this.requestHeaderList) {
                httpGet.addHeader(header);
            }
            httpEntity = null;
            try {
                String urlValue;
                RobotsTxt.Directive directive;
                RobotsTxt robotsTxt;
                HttpResponse response = this.executeHttpClient((HttpUriRequest)httpGet);
                httpEntity = response.getEntity();
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode != 200) break block18;
                Header contentLengthHeader = response.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    long maxLength;
                    String value = contentLengthHeader.getValue();
                    long contentLength = Long.parseLong(value);
                    if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                        throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                    }
                }
                if (httpEntity == null || (robotsTxt = this.robotsTxtHelper.parse(httpEntity.getContent())) == null) break block18;
                String[] sitemaps = robotsTxt.getSitemaps();
                if (sitemaps.length > 0) {
                    crawlerContext.addSitemaps(sitemaps);
                }
                if ((directive = robotsTxt.getMatchedDirective(this.userAgent)) == null) break block18;
                if (this.useRobotsTxtDisallows) {
                    for (String urlPattern : directive.getDisallows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        urlValue = hostUrl + urlPattern;
                        crawlerContext.getUrlFilter().addExclude(urlValue);
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Excluded URL: {}", (Object)urlValue);
                    }
                }
                if (this.useRobotsTxtAllows) {
                    for (String urlPattern : directive.getAllows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        urlValue = hostUrl + urlPattern;
                        crawlerContext.getUrlFilter().addInclude(urlValue);
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Included URL: {}", (Object)urlValue);
                    }
                }
            }
            catch (CrawlerSystemException e) {
                try {
                    httpGet.abort();
                    throw e;
                    catch (Exception e2) {
                        httpGet.abort();
                        throw new CrawlingAccessException("Could not process " + robotTxtUrl + ". ", e2);
                    }
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly(httpEntity);
                    throw throwable;
                }
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
    }

    protected String convertRobotsTxtPathPattern(String path) {
        Object newPath = path.replace(".", "\\.").replace("?", "\\?").replace("*", ".*");
        if (((String)newPath).charAt(0) != '/') {
            newPath = ".*" + (String)newPath;
        }
        if (!((String)newPath).endsWith("$") && !((String)newPath).endsWith(".*")) {
            newPath = (String)newPath + ".*";
        }
        return ((String)newPath).replace(".*.*", ".*");
    }

    @Override
    public ResponseData doGet(String url) {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(url);
        }
        catch (IllegalArgumentException e) {
            throw new CrawlingAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpGet);
    }

    @Override
    public ResponseData doHead(String url) {
        HttpHead httpHead;
        try {
            httpHead = new HttpHead(url);
        }
        catch (IllegalArgumentException e) {
            throw new CrawlingAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData doHttpMethod(String url, HttpUriRequest httpRequest) {
        if (this.httpClient == null) {
            this.init();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Accessing {}", (Object)url);
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.processHttpMethod(url, httpRequest);
            return responseData;
        }
        finally {
            if (accessTimeoutTarget != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResponseData processHttpMethod(String url, HttpUriRequest httpRequest) {
        block51: {
            try {
                this.processRobotsTxt(url);
            }
            catch (CrawlingAccessException e) {
                if (HcHttpClient.logger.isInfoEnabled()) {
                    buf = new StringBuilder(100);
                    buf.append(e.getMessage());
                    if (e.getCause() != null) {
                        buf.append(e.getCause().getMessage());
                    }
                    HcHttpClient.logger.info(buf.toString());
                }
                if (!HcHttpClient.logger.isDebugEnabled()) break block51;
                HcHttpClient.logger.debug("Crawling Access Exception at {}", (Object)url, (Object)e);
            }
        }
        for (Header header : this.requestHeaderList) {
            httpRequest.addHeader(header);
        }
        responseData = new ResponseData();
        httpEntity = null;
        try {
            response = this.executeHttpClient(httpRequest);
            httpEntity = response.getEntity();
            httpStatusCode = response.getStatusLine().getStatusCode();
            if (!this.isRedirectHttpStatus(httpStatusCode)) ** GOTO lbl63
            locationHeader = response.getFirstHeader("location");
            if (locationHeader != null) {
                redirectLocation = locationHeader.getValue().startsWith("/") != false ? HcHttpClient.buildRedirectLocation(url, locationHeader.getValue()) : locationHeader.getValue();
                responseData = new ResponseData();
                responseData.setRedirectLocation(redirectLocation);
                var9_18 = responseData;
            }
            ** GOTO lbl-1000
        }
        catch (UnknownHostException e) {
            try {
                this.closeResources(httpRequest, responseData);
                throw new CrawlingAccessException("Unknown host(" + e.getMessage() + "): " + url, e);
                catch (NoRouteToHostException e) {
                    this.closeResources(httpRequest, responseData);
                    throw new CrawlingAccessException("No route to host(" + e.getMessage() + "): " + url, e);
                }
                catch (ConnectException e) {
                    this.closeResources(httpRequest, responseData);
                    throw new CrawlingAccessException("Connection time out(" + e.getMessage() + "): " + url, e);
                }
                catch (SocketException e) {
                    this.closeResources(httpRequest, responseData);
                    throw new CrawlingAccessException("Socket exception(" + e.getMessage() + "): " + url, e);
                }
                catch (IOException e) {
                    this.closeResources(httpRequest, responseData);
                    throw new CrawlingAccessException("I/O exception(" + e.getMessage() + "): " + url, e);
                }
                catch (CrawlerSystemException e) {
                    this.closeResources(httpRequest, responseData);
                    throw e;
                }
                catch (Exception e) {
                    this.closeResources(httpRequest, responseData);
                    throw new CrawlerSystemException("Failed to access " + url, e);
                }
            }
            catch (Throwable var18_43) {
                EntityUtils.consumeQuietly(httpEntity);
                throw var18_43;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return var9_18;
lbl-1000:
        // 1 sources

        {
            HcHttpClient.logger.warn("Invalid redirect location at {}", (Object)url);
lbl63:
            // 2 sources

            contentType = null;
            contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(59)) > 0 && "application/octet-stream".equals(contentType = contentType.substring(0, idx))) {
                contentType = null;
            }
            contentLength = 0L;
            contentEncoding = "UTF-8";
            if (httpEntity == null) {
                responseData.setResponseBody(new byte[0]);
                if (contentType == null) {
                    contentType = this.defaultMimeType;
                }
            } else {
                block52: {
                    responseBodyStream = httpEntity.getContent();
                    dfos = new DeferredFileOutputStream((int)this.maxCachedContentSize, "crawler-HcHttpClient-", ".out", SystemUtils.getJavaIoTmpDir());
                    try {
                        CopyUtil.copy((InputStream)responseBodyStream, (OutputStream)dfos);
                        dfos.flush();
                        if (dfos.isInMemory()) {
                            responseData.setResponseBody(dfos.getData());
                            contentLength = dfos.getData().length;
                            if (contentType != null) break block52;
                            try {
                                is = new ByteArrayInputStream(dfos.getData());
                                try {
                                    contentType = this.mimeTypeHelper.getContentType((InputStream)is, url);
                                    break block52;
                                }
                                finally {
                                    is.close();
                                }
                            }
                            catch (Exception e) {
                                HcHttpClient.logger.debug("Failed to detect mime-type.", (Throwable)e);
                                contentType = this.defaultMimeType;
                            }
                            break block52;
                        }
                        outputFile = dfos.getFile();
                        responseData.setResponseBody(outputFile, true);
                        contentLength = outputFile.length();
                        if (contentType != null) break block52;
                        try {
                            is = new FileInputStream(outputFile);
                            try {
                                contentType = this.mimeTypeHelper.getContentType((InputStream)is, url);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (Exception e) {
                            HcHttpClient.logger.debug("Failed to detect mime-type.", (Throwable)e);
                            contentType = this.defaultMimeType;
                        }
                    }
                    finally {
                        dfos.close();
                    }
                }
                if ((contentEncodingHeader = httpEntity.getContentEncoding()) != null) {
                    contentEncoding = contentEncodingHeader.getValue();
                }
            }
            if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
            }
            responseData.setUrl(url);
            responseData.setCharSet(contentEncoding);
            if (httpRequest instanceof HttpHead) {
                responseData.setMethod("HEAD");
            } else {
                responseData.setMethod("GET");
            }
            responseData.setHttpStatusCode(httpStatusCode);
            for (Header header : response.getAllHeaders()) {
                responseData.addMetaData(header.getName(), header.getValue());
            }
            responseData.setMimeType(contentType);
            contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader == null) {
                responseData.setContentLength(contentLength);
            } else {
                value = contentLengthHeader.getValue();
                try {
                    responseData.setContentLength(Long.parseLong(value));
                }
                catch (Exception e) {
                    responseData.setContentLength(contentLength);
                }
            }
            this.checkMaxContentLength(responseData);
            lastModifiedHeader = response.getFirstHeader("Last-Modified");
            if (lastModifiedHeader != null && StringUtil.isNotBlank((String)(value = lastModifiedHeader.getValue())) && (d = this.parseLastModified(value)) != null) {
                responseData.setLastModified(d);
            }
            var14_35 = responseData;
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return var14_35;
    }

    protected void closeResources(HttpUriRequest httpRequest, ResponseData responseData) {
        CloseableUtil.closeQuietly((Closeable)responseData);
        httpRequest.abort();
    }

    protected boolean isRedirectHttpStatus(int httpStatusCode) {
        return this.redirectHttpStatusPattern.matcher(Integer.toString(httpStatusCode)).matches();
    }

    protected HttpResponse executeHttpClient(HttpUriRequest httpRequest) throws IOException {
        return this.httpClient.execute(httpRequest, (HttpContext)new BasicHttpContext((HttpContext)this.httpClientContext));
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected HttpRoutePlanner buildRoutePlanner() {
        if (this.routePlanner != null) {
            return this.routePlanner;
        }
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost, String.class);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort, Integer.class);
        if (proxyHost != null && proxyPort != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            DefaultProxyRoutePlanner defaultRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            Credentials credentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials, Credentials.class);
            if (credentials != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), credentials);
                AuthScheme authScheme = this.getInitParameter(PROXY_AUTH_SCHEME_PROPERTY, this.proxyAuthScheme, AuthScheme.class);
                if (authScheme != null) {
                    this.authCache.put(proxy, authScheme);
                }
            }
            return defaultRoutePlanner;
        }
        return null;
    }

    protected static String buildRedirectLocation(String url, String location) throws MalformedURLException {
        return new URL(new URL(url), location).toExternalForm();
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setCookieSpec(String cookieSpec) {
        this.cookieSpec = cookieSpec;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyAuthScheme(AuthScheme proxyAuthScheme) {
        this.proxyAuthScheme = proxyAuthScheme;
    }

    public void setProxyCredentials(Credentials proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setHttpClientContext(HttpClientContext httpClientContext) {
        this.httpClientContext = httpClientContext;
    }

    public void setAuthSchemeProviderMap(Map<String, AuthSchemeProvider> authSchemeProviderMap) {
        this.authSchemeProviderMap = authSchemeProviderMap;
    }

    public void setConnectionCheckInterval(int connectionCheckInterval) {
        this.connectionCheckInterval = connectionCheckInterval;
    }

    public void setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void setRedirectHttpStatusPattern(Pattern redirectHttpStatusPattern) {
        this.redirectHttpStatusPattern = redirectHttpStatusPattern;
    }

    public void setUseRobotsTxtDisallows(boolean useRobotsTxtDisallows) {
        this.useRobotsTxtDisallows = useRobotsTxtDisallows;
    }

    public void setUseRobotsTxtAllows(boolean useRobotsTxtAllows) {
        this.useRobotsTxtAllows = useRobotsTxtAllows;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setAuthCache(AuthCache authCache) {
        this.authCache = authCache;
    }

    public void setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    public void setCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.cookieSpecRegistry = cookieSpecRegistry;
    }

    public void setCookieDatePatterns(String[] cookieDatePatterns) {
        this.cookieDatePatterns = cookieDatePatterns;
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    public void setSslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

