/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.Map;
import javax.annotation.Resource;
import org.codelibs.fess.crawler.client.CrawlerClient;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrawlerClient
implements CrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCrawlerClient.class);
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String ACCESS_TIMEOUT_PROPERTY = "accessTimeout";
    public static final String MAX_CONTENT_LENGTH = "maxContentLength";
    public static final String MAX_CACHED_CONTENT_SIZE = "maxCachedContentSize";
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected Map<String, Object> initParamMap;
    protected long maxCachedContentSize = 0x100000L;
    protected Integer accessTimeout = null;
    protected Long maxContentLength = null;

    public void init() {
        Long maxCachedContentSizeParam;
        Integer accessTimeoutParam;
        Long maxContentLengthParam = this.getInitParameter(MAX_CONTENT_LENGTH, this.maxContentLength, Long.class);
        if (maxContentLengthParam != null) {
            this.maxContentLength = maxContentLengthParam;
        }
        if ((accessTimeoutParam = this.getInitParameter(ACCESS_TIMEOUT_PROPERTY, this.accessTimeout, Integer.class)) != null) {
            this.accessTimeout = accessTimeoutParam;
        }
        if ((maxCachedContentSizeParam = this.getInitParameter(MAX_CACHED_CONTENT_SIZE, null, Long.class)) != null) {
            this.maxCachedContentSize = maxCachedContentSizeParam;
        }
    }

    protected <T> T getInitParameter(String key, T defaultValue, Class<T> clazz) {
        if (this.initParamMap != null) {
            try {
                Object paramValue = this.initParamMap.get(key);
                if (paramValue == null) {
                    return defaultValue;
                }
                return this.convertObj(paramValue, clazz);
            }
            catch (Exception e) {
                logger.warn("Could not load init parameters: " + key + " from " + this.initParamMap, (Throwable)e);
            }
        }
        return defaultValue;
    }

    protected <T> T convertObj(Object value, Class<T> clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return (T)value.toString();
        }
        if (clazz.isAssignableFrom(Long.class)) {
            if (!(value instanceof Long)) {
                return (T)Long.valueOf(value.toString());
            }
        } else if (clazz.isAssignableFrom(Integer.class)) {
            if (!(value instanceof Integer)) {
                return (T)Integer.valueOf(value.toString());
            }
        } else if (clazz.isAssignableFrom(Double.class)) {
            if (!(value instanceof Double)) {
                return (T)Double.valueOf(value.toString());
            }
        } else if (clazz.isAssignableFrom(Float.class)) {
            if (!(value instanceof Float)) {
                return (T)Float.valueOf(value.toString());
            }
        } else if (clazz.isAssignableFrom(Boolean.class) && !(value instanceof Boolean)) {
            return (T)Boolean.valueOf(value.toString());
        }
        return (T)value;
    }

    @Override
    public void setInitParameterMap(Map<String, Object> params) {
        this.initParamMap = params;
    }

    @Override
    public ResponseData execute(RequestData request) {
        return switch (request.getMethod()) {
            case RequestData.Method.GET -> this.doGet(request.getUrl());
            case RequestData.Method.HEAD -> this.doHead(request.getUrl());
            case RequestData.Method.POST -> this.doPost(request.getUrl());
            default -> throw new CrawlerSystemException(request.getMethod() + " method is not supported.");
        };
    }

    protected void checkMaxContentLength(ResponseData responseData) {
        if (this.maxContentLength != null && responseData.getContentLength() > this.maxContentLength) {
            throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + this.maxContentLength + " byte. The url is " + responseData.getUrl());
        }
    }

    protected ResponseData doGet(String url) {
        throw new CrawlerSystemException("GET method is not supported.");
    }

    protected ResponseData doHead(String url) {
        throw new CrawlerSystemException("HEAD method is not supported.");
    }

    protected ResponseData doPost(String url) {
        throw new CrawlerSystemException("POST method is not supported.");
    }

    public void setMaxCachedContentSize(long maxCachedContentSize) {
        this.maxCachedContentSize = maxCachedContentSize;
    }

    public void setAccessTimeout(Integer accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public void setMaxContentLength(Long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }
}

