/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action.indices.create;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.tasks.Task;

public class HttpCreateIndexRequest
extends CreateIndexRequest {
    private final CreateIndexRequest request;

    public HttpCreateIndexRequest(CreateIndexRequest request) {
        this.request = request;
    }

    public CreateIndexRequest source(byte[] source, MediaType mediaType) {
        return this.source(source, 0, source.length, mediaType);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length, MediaType mediaType) {
        return this.source((BytesReference)new BytesArray(source, offset, length), mediaType);
    }

    public CreateIndexRequest source(String source, MediaType mediaType) {
        return this.source((BytesReference)new BytesArray(source), mediaType);
    }

    @Deprecated
    public CreateIndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source((BytesReference)new BytesArray(source, offset, length), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes((XContentBuilder)source), source.contentType());
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(HttpCreateIndexRequest.prepareMappings((Map)XContentHelper.convertToMap((BytesReference)source, (boolean)false, (XContentType)xContentType).v2()), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequest source(BytesReference source, MediaType mediaType) {
        Objects.requireNonNull(mediaType);
        this.source(HttpCreateIndexRequest.prepareMappings((Map)XContentHelper.convertToMap((BytesReference)source, (boolean)false, (MediaType)mediaType).v2()), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public static Map<String, Object> prepareMappings(Map<String, Object> source) {
        if (!source.containsKey("mappings") || !(source.get("mappings") instanceof Map)) {
            return source;
        }
        HashMap<String, Object> newSource = new HashMap<String, Object>(source);
        Map mappings = (Map)source.get("mappings");
        if (MapperService.isMappingSourceTyped((String)"_doc", (Map)mappings)) {
            throw new IllegalArgumentException("The mapping definition cannot be nested under a type");
        }
        newSource.put("mappings", Collections.singletonMap("_doc", mappings));
        return newSource;
    }

    public void setParentTask(String parentTaskNode, long parentTaskId) {
        this.request.setParentTask(parentTaskNode, parentTaskId);
    }

    public void remoteAddress(TransportAddress remoteAddress) {
        this.request.remoteAddress(remoteAddress);
    }

    public TransportAddress remoteAddress() {
        return this.request.remoteAddress();
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return this.request.createTask(id, type, action, parentTaskId, headers);
    }

    public boolean getShouldStoreResult() {
        return this.request.getShouldStoreResult();
    }

    public boolean includeDataStreams() {
        return this.request.includeDataStreams();
    }

    public void setParentTask(TaskId taskId) {
        this.request.setParentTask(taskId);
    }

    public String getDescription() {
        return this.request.getDescription();
    }

    public TaskId getParentTask() {
        return this.request.getParentTask();
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    public boolean equals(Object obj) {
        return this.request.equals(obj);
    }

    public ActionRequestValidationException validate() {
        return this.request.validate();
    }

    public String[] indices() {
        return this.request.indices();
    }

    public IndicesOptions indicesOptions() {
        return this.request.indicesOptions();
    }

    public String index() {
        return this.request.index();
    }

    public CreateIndexRequest index(String index) {
        this.request.index(index);
        return this;
    }

    public Settings settings() {
        return this.request.settings();
    }

    public String cause() {
        return this.request.cause();
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.request.settings(settings);
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.request.settings(settings);
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.request.settings(source, xContentType);
        return this;
    }

    public CreateIndexRequest settings(Map<String, ?> source) {
        this.request.settings(source);
        return this;
    }

    public CreateIndexRequest mapping(String mapping) {
        this.request.mapping(mapping);
        return this;
    }

    public String toString() {
        return this.request.toString();
    }

    public CreateIndexRequest cause(String cause) {
        this.request.cause(cause);
        return this;
    }

    public CreateIndexRequest aliases(Map<String, ?> source) {
        this.request.aliases(source);
        return this;
    }

    public CreateIndexRequest aliases(BytesReference source) {
        this.request.aliases(source);
        return this;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.request.alias(alias);
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source, DeprecationHandler deprecationHandler) {
        this.request.source(source, deprecationHandler);
        return this;
    }

    public String mappings() {
        return this.request.mappings();
    }

    public Set<Alias> aliases() {
        return this.request.aliases();
    }

    public ActiveShardCount waitForActiveShards() {
        return this.request.waitForActiveShards();
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.request.waitForActiveShards(waitForActiveShards);
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        this.request.waitForActiveShards(waitForActiveShards);
        return this;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.request.writeTo(out);
    }
}

