/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.VersionType;

public class HttpUpdateAction
extends HttpAction {
    protected final UpdateAction action;

    public HttpUpdateAction(HttpClient client, UpdateAction action) {
        super(client);
        this.action = action;
    }

    public void execute(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        String source = null;
        try (XContentBuilder builder = request.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                UpdateResponse updateResponse = this.fromXContent(parser);
                listener.onResponse((Object)updateResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected UpdateResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        UpdateResponse.Builder context = new UpdateResponse.Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            UpdateResponse.parseXContentFields((XContentParser)parser, (UpdateResponse.Builder)context);
        }
        return context.build();
    }

    protected CurlRequest getCurlRequest(UpdateRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_update/" + UrlUtils.encode(request.id()), request.index());
        if (request.routing() != null) {
            curlRequest.param("routing", request.routing());
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (!WriteRequest.RefreshPolicy.NONE.equals((Object)request.getRefreshPolicy())) {
            curlRequest.param("refresh", request.getRefreshPolicy().getValue());
        }
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        curlRequest.param("doc_as_upsert", Boolean.toString(request.docAsUpsert()));
        curlRequest.param("retry_on_conflict", String.valueOf(request.retryOnConflict()));
        curlRequest.param("if_seq_no", Long.toString(request.ifSeqNo()));
        curlRequest.param("if_primary_term", Long.toString(request.ifPrimaryTerm()));
        if (request.version() >= 0L) {
            curlRequest.param("version", Long.toString(request.version()));
        }
        if (!VersionType.INTERNAL.equals((Object)request.versionType())) {
            curlRequest.param("version_type", request.versionType().name().toLowerCase(Locale.ROOT));
        }
        return curlRequest;
    }
}

