/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollAction;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpSearchScrollAction
extends HttpAction {
    protected final SearchScrollAction action;

    public HttpSearchScrollAction(HttpClient client, SearchScrollAction action) {
        super(client);
        this.action = action;
    }

    public void execute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        String source = null;
        try (XContentBuilder builder = request.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                SearchResponse scrollResponse = SearchResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)scrollResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(SearchScrollRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_search/scroll", new String[0]);
        if (request.scrollId() != null) {
            curlRequest.param("scroll_id", request.scrollId());
        }
        if (request.scroll() != null) {
            curlRequest.param("scroll", request.scroll().keepAlive().toString());
        }
        return curlRequest;
    }
}

