/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchType;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.builder.SearchSourceBuilder;

public class HttpSearchAction
extends HttpAction {
    protected final SearchAction action;

    public HttpSearchAction(HttpClient client, SearchAction action) {
        super(client);
        this.action = action;
    }

    public void execute(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.getCurlRequest(request).body(this.getQuerySource(request)).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)parser);
                if (searchResponse.getHits() == null) {
                    listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, (Throwable)new OpenSearchException("hits is null.", new Object[0])));
                } else {
                    listener.onResponse((Object)searchResponse);
                }
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected String getQuerySource(SearchRequest request) {
        SearchSourceBuilder source = request.source();
        if (source != null) {
            try {
                return XContentHelper.toXContent((ToXContent)source, (MediaType)XContentType.JSON, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)false).utf8ToString();
            }
            catch (IOException e) {
                throw new OpenSearchException((Throwable)e);
            }
        }
        return null;
    }

    protected CurlRequest getCurlRequest(SearchRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_search", request.indices());
        curlRequest.param("typed_keys", "true");
        curlRequest.param("batched_reduce_size", Integer.toString(request.getBatchedReduceSize()));
        if (request.getPreFilterShardSize() != null) {
            curlRequest.param("pre_filter_shard_size", request.getPreFilterShardSize().toString());
        }
        if (request.getMaxConcurrentShardRequests() > 0) {
            curlRequest.param("max_concurrent_shard_requests", Integer.toString(request.getMaxConcurrentShardRequests()));
        }
        if (request.allowPartialSearchResults() != null) {
            curlRequest.param("allow_partial_search_results", request.allowPartialSearchResults().toString());
        }
        if (!SearchType.DEFAULT.equals((Object)request.searchType())) {
            curlRequest.param("search_type", request.searchType().name().toLowerCase());
        }
        if (request.requestCache() != null) {
            curlRequest.param("request_cache", request.requestCache().toString());
        }
        if (request.scroll() != null) {
            curlRequest.param("scroll", request.scroll().keepAlive().toString());
        }
        if (request.routing() != null) {
            curlRequest.param("routing", request.routing());
        }
        if (request.preference() != null) {
            curlRequest.param("preference", request.preference());
        }
        curlRequest.param("ccs_minimize_roundtrips", Boolean.toString(request.isCcsMinimizeRoundtrips()));
        return curlRequest;
    }
}

