/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsAction;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionListener;

public class HttpNodesHotThreadsAction
extends HttpAction {
    protected NodesHotThreadsAction action;

    public HttpNodesHotThreadsAction(HttpClient client, NodesHotThreadsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(NodesHotThreadsRequest request, ActionListener<NodesHotThreadsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), StandardCharsets.UTF_8));){
                ArrayList<NodeHotThreads> nodes = new ArrayList<NodeHotThreads>();
                DiscoveryNode node = null;
                StringBuilder buf = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("::: ")) {
                        if (node != null) {
                            nodes.add(new NodeHotThreads(node, buf.toString().trim()));
                            buf.setLength(0);
                        }
                        node = this.parseDiscoveryNode(line);
                        continue;
                    }
                    buf.append(line).append('\n');
                }
                if (node != null) {
                    nodes.add(new NodeHotThreads(node, buf.toString().trim()));
                }
                listener.onResponse((Object)new NodesHotThreadsResponse(new ClusterName(this.client.getEngineInfo().getClusterName()), nodes, Collections.emptyList()));
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected DiscoveryNode parseDiscoveryNode(String line) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isTarget = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '{') {
                isTarget = true;
                continue;
            }
            if (line.charAt(i) == '}') {
                isTarget = false;
                list.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            if (!isTarget) continue;
            buf.append(line.charAt(i));
        }
        if (list.size() >= 5) {
            try {
                return new DiscoveryNode((String)list.get(0), (String)list.get(1), (String)list.get(2), (String)list.get(3), (String)list.get(4), null, Collections.emptyMap(), Collections.emptySet(), Version.V_EMPTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.size() >= 4) {
            try {
                return new DiscoveryNode((String)list.get(0), (String)list.get(1), (String)list.get(2), (String)list.get(3), "0.0.0.0", null, Collections.emptyMap(), Collections.emptySet(), Version.V_EMPTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.size() >= 3) {
            return new DiscoveryNode((String)list.get(0), (String)list.get(1), (String)list.get(2), "unknown", "0.0.0.0", null, Collections.emptyMap(), Collections.emptySet(), Version.V_EMPTY);
        }
        if (list.size() >= 2) {
            return new DiscoveryNode((String)list.get(0), (String)list.get(1), "unknown", "unknown", "0.0.0.0", null, Collections.emptyMap(), Collections.emptySet(), Version.V_EMPTY);
        }
        return new DiscoveryNode("unknown", "unknown", "unknown", "unknown", "0.0.0.0", null, Collections.emptyMap(), Collections.emptySet(), Version.V_EMPTY);
    }

    protected CurlRequest getCurlRequest(NodesHotThreadsRequest request) {
        StringBuilder buf = new StringBuilder();
        buf.append("/_nodes");
        if (request.nodesIds() != null && request.nodesIds().length > 0) {
            buf.append('/').append(String.join((CharSequence)",", request.nodesIds()));
        }
        buf.append("/hot_threads");
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, buf.toString(), new String[0]);
        curlRequest.param("threads", String.valueOf(request.threads()));
        curlRequest.param("ignore_idle_threads", request.ignoreIdleThreads() ? "true" : "false");
        if (request.type() != null) {
            curlRequest.param("type", request.type());
        }
        if (request.interval() != null) {
            curlRequest.param("interval", request.interval().toString());
        }
        curlRequest.param("snapshots", String.valueOf(request.snapshots()));
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        return curlRequest;
    }
}

