/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpListTasksAction
extends HttpAction {
    protected final ListTasksAction action;

    public HttpListTasksAction(HttpClient client, ListTasksAction action) {
        super(client);
        this.action = action;
    }

    public void execute(ListTasksRequest request, ActionListener<ListTasksResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                ListTasksResponse listTasksResponse = ListTasksResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)listTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(ListTasksRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_tasks", new String[0]);
        curlRequest.param("detailed", String.valueOf(request.getDetailed()));
        curlRequest.param("parent_task_id", String.valueOf(request.getParentTaskId()));
        curlRequest.param("wait_for_completion", String.valueOf(request.getWaitForCompletion()));
        if (request.getNodes() != null) {
            curlRequest.param("nodes", String.join((CharSequence)",", request.getNodes()));
        }
        if (request.getActions() != null) {
            curlRequest.param("actions", String.join((CharSequence)",", request.getActions()));
        }
        return curlRequest;
    }
}

