/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexAction;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.VersionType;

public class HttpIndexAction
extends HttpAction {
    protected final IndexAction action;

    public HttpIndexAction(HttpClient client, IndexAction action) {
        super(client);
        this.action = action;
    }

    public void execute(IndexRequest request, ActionListener<IndexResponse> listener) {
        String source = null;
        try {
            source = XContentHelper.convertToJson((BytesReference)request.source(), (boolean)false, (MediaType)XContentType.JSON);
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                IndexResponse indexResponse = this.fromXContent(parser);
                listener.onResponse((Object)indexResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected IndexResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        IndexResponse.Builder context = new IndexResponse.Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            IndexResponse.parseXContentFields((XContentParser)parser, (IndexResponse.Builder)context);
        }
        return context.build();
    }

    protected CurlRequest getCurlRequest(IndexRequest request) {
        DocWriteRequest.OpType opType = request.id() == null ? DocWriteRequest.OpType.CREATE : request.opType();
        boolean isPutMethod = request.id() != null;
        StringBuilder pathBuf = new StringBuilder(100).append("/_doc");
        if (request.id() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.id()));
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)(isPutMethod ? PUT : POST), pathBuf.toString(), request.index());
        if (request.routing() != null) {
            curlRequest.param("routing", request.routing());
        }
        if (request.getPipeline() != null) {
            curlRequest.param("pipeline", request.getPipeline());
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (!WriteRequest.RefreshPolicy.NONE.equals((Object)request.getRefreshPolicy())) {
            curlRequest.param("refresh", request.getRefreshPolicy().getValue());
        }
        if (request.version() >= 0L) {
            curlRequest.param("version", Long.toString(request.version()));
        }
        if (!VersionType.INTERNAL.equals((Object)request.versionType())) {
            curlRequest.param("version_type", request.versionType().name().toLowerCase(Locale.ROOT));
        }
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        if (request.id() != null) {
            curlRequest.param("op_type", opType.getLowercase());
        }
        return curlRequest;
    }
}

