/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.indices.settings.get.GetSettingsAction;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpGetSettingsAction
extends HttpAction {
    protected final GetSettingsAction action;

    public HttpGetSettingsAction(HttpClient client, GetSettingsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetSettingsRequest request, ActionListener<GetSettingsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetSettingsResponse getSettingsResponse = GetSettingsResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)getSettingsResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetSettingsRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_settings/" + UrlUtils.joinAndEncode(",", request.names()), request.indices());
        curlRequest.param("human", Boolean.toString(request.humanReadable()));
        curlRequest.param("include_defaults", Boolean.toString(request.includeDefaults()));
        curlRequest.param("local", Boolean.toString(request.local()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

