/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpGetRepositoriesAction
extends HttpAction {
    protected final GetRepositoriesAction action;

    public HttpGetRepositoriesAction(HttpClient client, GetRepositoriesAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetRepositoriesRequest request, ActionListener<GetRepositoriesResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetRepositoriesResponse getRepositoriesResponse = GetRepositoriesResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)getRepositoriesResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetRepositoriesRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_snapshot", new String[0]);
        curlRequest.param("local", Boolean.toString(request.local()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        if (request.repositories() != null) {
            curlRequest.param("repository", String.join((CharSequence)",", request.repositories()));
        }
        return curlRequest;
    }
}

