/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.EngineInfo;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;

public class HttpGetMappingsAction
extends HttpAction {
    protected final GetMappingsAction action;
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);

    public HttpGetMappingsAction(HttpClient client, GetMappingsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetMappingsRequest request, ActionListener<GetMappingsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            if (response.getHttpStatusCode() == 404) {
                throw new IndexNotFoundException(String.join((CharSequence)",", request.indices()));
            }
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetMappingsResponse getMappingsResponse = HttpGetMappingsAction.fromXContent(parser);
                listener.onResponse((Object)getMappingsResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetMappingsRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_mapping", request.indices());
        if (this.client.getEngineInfo().getType() != EngineInfo.EngineType.ELASTICSEARCH8) {
            curlRequest.param("local", Boolean.toString(request.local()));
        }
        return curlRequest;
    }

    public static GetMappingsResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        Map parts = parser.map();
        HashMap mappings = new HashMap();
        for (Map.Entry entry : parts.entrySet()) {
            entry.getKey();
            Map mapping = (Map)((Map)entry.getValue()).get(MAPPINGS.getPreferredName());
            HashMap<String, MappingMetadata> typeBuilder = new HashMap<String, MappingMetadata>();
            for (Map.Entry typeEntry : mapping.entrySet()) {
                String typeName = (String)typeEntry.getKey();
                if ("dynamic_templates".equals(typeName)) continue;
                Map fieldMappings = (Map)typeEntry.getValue();
                MappingMetadata mmd = new MappingMetadata(typeName, fieldMappings);
                typeBuilder.put(typeName, mmd);
            }
            mappings = typeBuilder;
        }
        return new GetMappingsResponse(mappings);
    }
}

