/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpGetIndexTemplatesAction
extends HttpAction {
    protected final GetIndexTemplatesAction action;

    public HttpGetIndexTemplatesAction(HttpClient client, GetIndexTemplatesAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetIndexTemplatesRequest request, ActionListener<GetIndexTemplatesResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetIndexTemplatesResponse getIndexTemplatesResponse = HttpGetIndexTemplatesAction.fromXContent(parser);
                listener.onResponse((Object)getIndexTemplatesResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetIndexTemplatesRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_template/" + UrlUtils.joinAndEncode(",", request.names()), new String[0]);
        curlRequest.param("local", Boolean.toString(request.local()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }

    private static GetIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<IndexTemplateMetadata> templates = new ArrayList<IndexTemplateMetadata>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                IndexTemplateMetadata templateMetadata = IndexTemplateMetadata.Builder.fromXContent((XContentParser)parser, (String)parser.currentName());
                templates.add(templateMetadata);
            }
            token = parser.nextToken();
        }
        return new GetIndexTemplatesResponse(templates);
    }
}

