/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.CollectionUtil;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.indices.get.GetIndexAction;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class HttpGetIndexAction
extends HttpAction {
    protected final GetIndexAction action;

    public HttpGetIndexAction(HttpClient client, GetIndexAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetIndexRequest request, ActionListener<GetIndexResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetIndexResponse getIndexResponse = HttpGetIndexAction.fromXContent(parser);
                listener.onResponse((Object)getIndexResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetIndexRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/", request.indices());
        curlRequest.param("include_defaults", Boolean.toString(request.includeDefaults()));
        return curlRequest;
    }

    protected static GetIndexResponse fromXContent(XContentParser parser) throws IOException {
        Map<Object, Object> mappings = new HashMap();
        HashMap<String, List<AliasMetadata>> aliases = new HashMap<String, List<AliasMetadata>>();
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        HashMap<String, Settings> defaultSettings = new HashMap<String, Settings>();
        HashMap<String, String> dataStreams = new HashMap<String, String>();
        ArrayList<String> indices = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String indexName = parser.currentName();
                indices.add(indexName);
                IndexEntry indexEntry = HttpGetIndexAction.parseIndexEntry(parser);
                CollectionUtil.timSort(indexEntry.indexAliases, Comparator.comparing(AliasMetadata::alias));
                aliases.put(indexName, Collections.unmodifiableList(indexEntry.indexAliases));
                mappings = indexEntry.indexMappings;
                settings.put(indexName, indexEntry.indexSettings);
                if (!indexEntry.indexDefaultSettings.isEmpty()) {
                    defaultSettings.put(indexName, indexEntry.indexDefaultSettings);
                }
                if (indexEntry.dataStream == null) continue;
                dataStreams.put(indexName, indexEntry.dataStream);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return new GetIndexResponse(indices.toArray(new String[0]), mappings, aliases, settings, defaultSettings, dataStreams);
    }

    protected static IndexEntry parseIndexEntry(XContentParser parser) throws IOException {
        List<AliasMetadata> indexAliases = null;
        Map<String, MappingMetadata> indexMappings = null;
        Settings indexSettings = null;
        Settings indexDefaultSettings = null;
        String dataStream = null;
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                switch (parser.currentName()) {
                    case "aliases": {
                        indexAliases = HttpGetIndexAction.parseAliases(parser);
                        continue block12;
                    }
                    case "mappings": {
                        indexMappings = HttpGetIndexAction.parseMappings(parser);
                        continue block12;
                    }
                    case "settings": {
                        indexSettings = Settings.fromXContent((XContentParser)parser);
                        continue block12;
                    }
                    case "defaults": {
                        indexDefaultSettings = Settings.fromXContent((XContentParser)parser);
                        continue block12;
                    }
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                if ("data_stream".equals(parser.currentName())) {
                    dataStream = parser.text();
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new IndexEntry(indexAliases, indexMappings, indexSettings, indexDefaultSettings, dataStream);
    }

    protected static List<AliasMetadata> parseAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            indexAliases.add(AliasMetadata.Builder.fromXContent((XContentParser)parser));
        }
        return indexAliases;
    }

    protected static Map<String, MappingMetadata> parseMappings(XContentParser parser) throws IOException {
        HashMap<String, MappingMetadata> indexMappings = new HashMap<String, MappingMetadata>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String mappingType = parser.currentName();
                indexMappings.put(mappingType, new MappingMetadata(mappingType, parser.map()));
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return indexMappings;
    }

    protected static class IndexEntry {
        List<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        Map<String, MappingMetadata> indexMappings = new HashMap<String, MappingMetadata>();
        Settings indexSettings = Settings.EMPTY;
        Settings indexDefaultSettings = Settings.EMPTY;
        String dataStream;

        IndexEntry(List<AliasMetadata> indexAliases, Map<String, MappingMetadata> indexMappings, Settings indexSettings, Settings indexDefaultSettings, String dataStream) {
            if (indexAliases != null) {
                this.indexAliases = indexAliases;
            }
            if (indexMappings != null) {
                this.indexMappings = indexMappings;
            }
            if (indexSettings != null) {
                this.indexSettings = indexSettings;
            }
            if (indexDefaultSettings != null) {
                this.indexDefaultSettings = indexDefaultSettings;
            }
            if (dataStream != null) {
                this.dataStream = dataStream;
            }
        }
    }
}

