/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.indices.flush.FlushAction;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpFlushAction
extends HttpAction {
    protected final FlushAction action;

    public HttpFlushAction(HttpClient client, FlushAction action) {
        super(client);
        this.action = action;
    }

    public void execute(FlushRequest request, ActionListener<FlushResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                FlushResponse flushResponse = FlushResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)flushResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(FlushRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_flush", request.indices());
        curlRequest.param("wait_if_ongoing", Boolean.toString(request.waitIfOngoing()));
        curlRequest.param("force", Boolean.toString(request.force()));
        return curlRequest;
    }
}

