/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.lucene.search.Explanation;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.EngineInfo;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.explain.ExplainAction;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.get.GetResult;

public class HttpExplainAction
extends HttpAction {
    protected final ExplainAction action;

    public HttpExplainAction(HttpClient client, ExplainAction action) {
        super(client);
        this.action = action;
    }

    public void execute(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        String source = null;
        try (XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field(QUERY_FIELD.getPreferredName(), (ToXContent)request.query()).endObject();){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                ExplainResponse explainResponse = this.fromXContent(parser, true);
                listener.onResponse((Object)explainResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected ExplainResponse fromXContent(XContentParser parser, boolean exists) {
        EngineInfo.EngineType engineType = this.client.getEngineInfo().getType();
        if (engineType == EngineInfo.EngineType.ELASTICSEARCH8 || engineType == EngineInfo.EngineType.OPENSEARCH2) {
            return (ExplainResponse)this.getResponseParser().apply(parser, (Object)exists);
        }
        return ExplainResponse.fromXContent((XContentParser)parser, (boolean)exists);
    }

    protected ConstructingObjectParser<ExplainResponse, Boolean> getResponseParser() {
        ConstructingObjectParser parser = new ConstructingObjectParser("explain", true, (arg, exists) -> new ExplainResponse((String)arg[0], (String)arg[1], exists.booleanValue(), (Explanation)arg[2], (GetResult)arg[3]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_index", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("_id", new String[0]));
        ConstructingObjectParser explanationParser = new ConstructingObjectParser("explanation", true, arg -> {
            if (((Float)arg[0]).floatValue() > 0.0f) {
                return Explanation.match((Number)Float.valueOf(((Float)arg[0]).floatValue()), (String)((String)arg[1]), (Collection)((Collection)arg[2]));
            }
            return Explanation.noMatch((String)((String)arg[1]), (Collection)((Collection)arg[2]));
        });
        explanationParser.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("value", new String[0]));
        explanationParser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("description", new String[0]));
        explanationParser.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)explanationParser, new ParseField("details", new String[0]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)explanationParser, new ParseField("explanation", new String[0]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GetResult.fromXContentEmbedded((XContentParser)p), new ParseField("get", new String[0]));
        return parser;
    }

    protected CurlRequest getCurlRequest(ExplainRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_explain/" + UrlUtils.encode(request.id()), request.index());
        if (request.routing() != null) {
            curlRequest.param("routing", request.routing());
        }
        if (request.preference() != null) {
            curlRequest.param("preference", request.preference());
        }
        if (request.query() != null) {
            // empty if block
        }
        if (request.storedFields() != null) {
            curlRequest.param("stored_fields", String.join((CharSequence)",", request.storedFields()));
        }
        return curlRequest;
    }
}

