/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpDeleteRepositoryAction
extends HttpAction {
    protected final DeleteRepositoryAction action;

    public HttpDeleteRepositoryAction(HttpClient client, DeleteRepositoryAction action) {
        super(client);
        this.action = action;
    }

    public void execute(DeleteRepositoryRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                AcknowledgedResponse deleteRepositoryResponse = AcknowledgedResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)deleteRepositoryResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(DeleteRepositoryRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)DELETE, "/_snapshot/" + UrlUtils.encode(request.name()), new String[0]);
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        return curlRequest;
    }
}

