/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpCreateSnapshotAction
extends HttpAction {
    protected final CreateSnapshotAction action;

    public HttpCreateSnapshotAction(HttpClient client, CreateSnapshotAction action) {
        super(client);
        this.action = action;
    }

    public void execute(CreateSnapshotRequest request, ActionListener<CreateSnapshotResponse> listener) {
        String source = null;
        try (XContentBuilder builder = request.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                CreateSnapshotResponse cancelTasksResponse = CreateSnapshotResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(CreateSnapshotRequest request) {
        StringBuilder pathBuf = new StringBuilder(100).append("/_snapshot");
        if (request.repository() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.repository()));
        }
        if (request.snapshot() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.snapshot()));
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, pathBuf.toString(), new String[0]);
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        curlRequest.param("wait_for_completion", String.valueOf(request.waitForCompletion()));
        return curlRequest;
    }
}

