/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpClusterRerouteAction
extends HttpAction {
    protected final ClusterRerouteAction action;

    public HttpClusterRerouteAction(HttpClient client, ClusterRerouteAction action) {
        super(client);
        this.action = action;
    }

    public void execute(ClusterRerouteRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                AcknowledgedResponse clusterRerouteResponse = ClusterRerouteResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)clusterRerouteResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(ClusterRerouteRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_cluster/reroute", new String[0]);
        if (request.dryRun()) {
            curlRequest.param("dry_run", Boolean.toString(request.dryRun()));
        }
        if (request.explain()) {
            curlRequest.param("explain", Boolean.toString(request.explain()));
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.isRetryFailed()) {
            curlRequest.param("retry_failed", Boolean.toString(request.isRetryFailed()));
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

