/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.io.stream.ByteArrayStreamOutput;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.health.ClusterStateHealth;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;

public class HttpClusterHealthAction
extends HttpAction {
    protected final ClusterHealthAction action;
    private static final String CLUSTER_NAME = "cluster_name";
    private static final String STATUS = "status";
    private static final String TIMED_OUT = "timed_out";
    private static final String NUMBER_OF_NODES = "number_of_nodes";
    private static final String NUMBER_OF_DATA_NODES = "number_of_data_nodes";
    private static final String NUMBER_OF_PENDING_TASKS = "number_of_pending_tasks";
    private static final String NUMBER_OF_IN_FLIGHT_FETCH = "number_of_in_flight_fetch";
    private static final String DELAYED_UNASSIGNED_SHARDS = "delayed_unassigned_shards";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = "task_max_waiting_in_queue_millis";
    private static final String ACTIVE_SHARDS_PERCENT_AS_NUMBER = "active_shards_percent_as_number";
    private static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String INDICES = "indices";
    private static final ConstructingObjectParser<ClusterHealthResponse, Void> PARSER = new ConstructingObjectParser("cluster_health_response", true, parsedObjects -> {
        ClusterHealthResponse clusterHealthResponse;
        Map<String, ClusterIndexHealth> indices;
        int i = 0;
        int numberOfNodes = (Integer)parsedObjects[i];
        int numberOfDataNodes = (Integer)parsedObjects[++i];
        boolean hasDiscoveredMaster = true;
        int activeShards = (Integer)parsedObjects[++i];
        int relocatingShards = (Integer)parsedObjects[++i];
        int activePrimaryShards = (Integer)parsedObjects[++i];
        int initializingShards = (Integer)parsedObjects[++i];
        int unassignedShards = (Integer)parsedObjects[++i];
        double activeShardsPercent = (Double)parsedObjects[++i];
        String statusStr = (String)parsedObjects[++i];
        ClusterHealthStatus status = ClusterHealthStatus.fromString((String)statusStr);
        List indexList = (List)parsedObjects[++i];
        ++i;
        if (indexList == null || indexList.isEmpty()) {
            indices = Collections.emptyMap();
        } else {
            indices = new HashMap(indexList.size());
            for (ClusterIndexHealth indexHealth : indexList) {
                indices.put(indexHealth.getIndex(), indexHealth);
            }
        }
        ClusterStateHealth stateHealth = new ClusterStateHealth(activePrimaryShards, activeShards, relocatingShards, initializingShards, unassignedShards, numberOfNodes, numberOfDataNodes, true, activeShardsPercent, status, indices);
        String clusterName = (String)parsedObjects[i];
        int numberOfPendingTasks = (Integer)parsedObjects[++i];
        int numberOfInFlightFetch = (Integer)parsedObjects[++i];
        int delayedUnassignedShards = (Integer)parsedObjects[++i];
        long taskMaxWaitingTimeMillis = (Long)parsedObjects[++i];
        boolean timedOut = (Boolean)parsedObjects[++i];
        ByteArrayStreamOutput out = new ByteArrayStreamOutput();
        try {
            out.writeString(clusterName);
            out.writeByte(stateHealth.getStatus().value());
            stateHealth.writeTo((StreamOutput)out);
            out.writeInt(numberOfPendingTasks);
            out.writeBoolean(timedOut);
            out.writeInt(numberOfInFlightFetch);
            out.writeInt(delayedUnassignedShards);
            out.writeTimeValue(TimeValue.timeValueMillis((long)taskMaxWaitingTimeMillis));
            out.writeBoolean(false);
            clusterHealthResponse = new ClusterHealthResponse(out.toStreamInput());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        out.close();
        return clusterHealthResponse;
    });
    private static final ObjectParser.NamedObjectParser<ClusterIndexHealth, Void> INDEX_PARSER = (parser, context, index) -> ClusterIndexHealth.innerFromXContent((XContentParser)parser, (String)index);

    public HttpClusterHealthAction(HttpClient client, ClusterHealthAction action) {
        super(client);
        this.action = action;
    }

    public void execute(ClusterHealthRequest request, ActionListener<ClusterHealthResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)PARSER.apply(parser, null);
                listener.onResponse((Object)clusterHealthResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(ClusterHealthRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_cluster/health" + (String)(request.indices() == null ? "" : "/" + UrlUtils.joinAndEncode(",", request.indices())), new String[0]);
        curlRequest.param("wait_for_no_relocating_shards", Boolean.toString(request.waitForNoRelocatingShards()));
        curlRequest.param("wait_for_no_initializing_shards", Boolean.toString(request.waitForNoInitializingShards()));
        curlRequest.param("wait_for_nodes", request.waitForNodes());
        if (request.waitForStatus() != null) {
            try {
                curlRequest.param("wait_for_status", ClusterHealthStatus.fromValue((byte)request.waitForStatus().value()).toString().toLowerCase());
            }
            catch (IOException e) {
                throw new OpenSearchException("Failed to parse a request.", (Throwable)e, new Object[0]);
            }
        }
        if (request.waitForActiveShards() != null) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", request.waitForActiveShards().toString());
        }
        if (request.waitForEvents() != null) {
            curlRequest.param("wait_for_events", request.waitForEvents().toString());
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_NODES, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_DATA_NODES, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(RELOCATING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_PRIMARY_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(INITIALIZING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS_PERCENT_AS_NUMBER, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATUS, new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), INDEX_PARSER, new ParseField(INDICES, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(CLUSTER_NAME, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_PENDING_TASKS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_IN_FLIGHT_FETCH, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(DELAYED_UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(TIMED_OUT, new String[0]));
    }
}

