/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpCancelTasksAction
extends HttpAction {
    protected final CancelTasksAction action;

    public HttpCancelTasksAction(HttpClient client, CancelTasksAction action) {
        super(client);
        this.action = action;
    }

    public void execute(CancelTasksRequest request, ActionListener<CancelTasksResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                CancelTasksResponse cancelTasksResponse = CancelTasksResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(CancelTasksRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_tasks/_cancel", new String[0]);
        curlRequest.param("task_id", String.valueOf(request.getTaskId()));
        curlRequest.param("parent_task_id", String.valueOf(request.getParentTaskId()));
        if (request.getNodes() != null) {
            curlRequest.param("nodes", String.join((CharSequence)",", request.getNodes()));
        }
        if (request.getActions() != null) {
            curlRequest.param("actions", String.join((CharSequence)",", request.getActions()));
        }
        return curlRequest;
    }
}

