/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.VersionType;

public class HttpBulkAction
extends HttpAction {
    private static final String ITEMS = "items";
    private static final String ERRORS = "errors";
    private static final String TOOK = "took";
    private static final String INGEST_TOOK = "ingest_took";
    private static final String STATUS = "status";
    private static final String ERROR = "error";
    protected final BulkAction action;

    public HttpBulkAction(HttpClient client, BulkAction action) {
        super(client);
        this.action = action;
    }

    public void execute(BulkRequest request, ActionListener<BulkResponse> listener) {
        StringBuilder buf = new StringBuilder(10000);
        try {
            List bulkRequests = request.requests();
            block13: for (DocWriteRequest req : bulkRequests) {
                buf.append(this.getStringfromDocWriteRequest(req));
                buf.append('\n');
                switch (req.opType().getId()) {
                    case 0: {
                        buf.append(XContentHelper.convertToJson((BytesReference)((IndexRequest)req).source(), (boolean)false, (MediaType)XContentType.JSON));
                        buf.append('\n');
                        break;
                    }
                    case 1: {
                        buf.append(XContentHelper.convertToJson((BytesReference)((IndexRequest)req).source(), (boolean)false, (MediaType)XContentType.JSON));
                        buf.append('\n');
                        break;
                    }
                    case 2: {
                        XContentBuilder builder = ((UpdateRequest)req).toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);
                        try {
                            builder.flush();
                            buf.append(BytesReference.bytes((XContentBuilder)builder).utf8ToString());
                            buf.append('\n');
                            continue block13;
                        }
                        finally {
                            if (builder == null) continue block13;
                            builder.close();
                            continue block13;
                        }
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(buf.toString()).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                BulkResponse bulkResponse = this.fromXContent(parser);
                listener.onResponse((Object)bulkResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected BulkResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        long took = -1L;
        long ingestTook = -1L;
        ArrayList<BulkItemResponse> items = new ArrayList<BulkItemResponse>();
        String currentFieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TOOK.equals(currentFieldName)) {
                    took = parser.longValue();
                    continue;
                }
                if (INGEST_TOOK.equals(currentFieldName)) {
                    ingestTook = parser.longValue();
                    continue;
                }
                if (ERRORS.equals(currentFieldName)) continue;
                XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (ITEMS.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        items.add(this.fromXContent(parser, items.size()));
                    }
                    continue;
                }
                XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentLocation)parser.getTokenLocation());
        }
        return new BulkResponse(items.toArray(new BulkItemResponse[items.size()]), took, ingestTook);
    }

    protected BulkItemResponse fromXContent(XContentParser parser, int id) throws IOException {
        BulkItemResponse bulkItemResponse;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String currentFieldName = parser.currentName();
        token = parser.nextToken();
        DocWriteRequest.OpType opType = DocWriteRequest.OpType.fromString((String)currentFieldName);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        IndexResponse.Builder builder = null;
        CheckedConsumer itemParser = null;
        if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
            IndexResponse.Builder indexResponseBuilder;
            builder = indexResponseBuilder = new IndexResponse.Builder();
            itemParser = indexParser -> IndexResponse.parseXContentFields((XContentParser)indexParser, (IndexResponse.Builder)indexResponseBuilder);
        } else if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateResponse.Builder updateResponseBuilder = new UpdateResponse.Builder();
            builder = updateResponseBuilder;
            itemParser = updateParser -> UpdateResponse.parseXContentFields((XContentParser)updateParser, (UpdateResponse.Builder)updateResponseBuilder);
        } else if (opType == DocWriteRequest.OpType.DELETE) {
            DeleteResponse.Builder deleteResponseBuilder = new DeleteResponse.Builder();
            builder = deleteResponseBuilder;
            itemParser = deleteParser -> DeleteResponse.parseXContentFields((XContentParser)deleteParser, (DeleteResponse.Builder)deleteResponseBuilder);
        } else {
            XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
        }
        RestStatus status = null;
        OpenSearchException exception = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (ERROR.equals(currentFieldName)) {
                if (token != XContentParser.Token.START_OBJECT) continue;
                exception = OpenSearchException.fromXContent((XContentParser)parser);
                continue;
            }
            if (STATUS.equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                status = RestStatus.fromCode((int)parser.intValue());
                continue;
            }
            itemParser.accept((Object)parser);
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        if (exception != null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(builder.getShardId().getIndexName(), builder.getId(), (Exception)exception, status);
            bulkItemResponse = new BulkItemResponse(id, opType, failure);
        } else {
            bulkItemResponse = new BulkItemResponse(id, opType, builder.build());
        }
        return bulkItemResponse;
    }

    protected CurlRequest getCurlRequest(BulkRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_bulk", new String[0]);
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (!WriteRequest.RefreshPolicy.NONE.equals((Object)request.getRefreshPolicy())) {
            curlRequest.param("refresh", request.getRefreshPolicy().getValue());
        }
        return curlRequest;
    }

    protected String getStringfromDocWriteRequest(DocWriteRequest<?> request) {
        StringBuilder buf = new StringBuilder(100);
        String opType = request.opType().getLowercase();
        buf.append("{\"").append(opType).append("\":{");
        this.appendStr(buf, "_index", request.index());
        if (request.id() != null) {
            this.appendStr(buf.append(','), "_id", request.id());
        }
        if (request.routing() != null) {
            this.appendStr(buf.append(','), "routing", request.routing());
        }
        if (request.version() >= 0L) {
            this.appendStr(buf.append(','), "version", request.version());
        }
        if (VersionType.INTERNAL.equals((Object)request.versionType())) {
            this.appendStr(buf.append(','), "version_type", request.versionType().name().toLowerCase(Locale.ROOT));
        }
        if (request.ifSeqNo() != -2L) {
            this.appendStr(buf.append(','), "if_seq_no", request.ifSeqNo());
        }
        if (request.ifPrimaryTerm() != 0L) {
            this.appendStr(buf.append(','), "if_primary_term", request.ifPrimaryTerm());
        }
        switch (request.opType()) {
            case INDEX: 
            case CREATE: {
                IndexRequest indexRequest = (IndexRequest)request;
                if (indexRequest.getPipeline() == null) break;
                this.appendStr(buf.append(','), "pipeline", indexRequest.getPipeline());
                break;
            }
            case UPDATE: {
                break;
            }
            case DELETE: {
                break;
            }
        }
        buf.append('}');
        buf.append('}');
        return buf.toString();
    }

    protected StringBuilder appendStr(StringBuilder buf, String key, long value) {
        return buf.append('\"').append(key).append("\":").append(value);
    }

    protected StringBuilder appendStr(StringBuilder buf, String key, String value) {
        return buf.append('\"').append(key).append("\":\"").append(value).append('\"');
    }
}

