/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.io.stream.ByteArrayStreamOutput;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BytesRestResponse;

public class HttpAction {
    protected static final ParseField SHARD_FIELD = new ParseField("shard", new String[0]);
    protected static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    protected static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    protected static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    protected static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
    protected static final ParseField MAPPINGS_FIELD = new ParseField("mappings", new String[0]);
    protected static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    protected static final ParseField DETAILS_FIELD = new ParseField("details", new String[0]);
    protected static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    protected static final ParseField TASKS_FIELD = new ParseField("tasks", new String[0]);
    protected static final ParseField INSERT_ORDER_FIELD = new ParseField("insert_order", new String[0]);
    protected static final ParseField PRIORITY_FIELD = new ParseField("priority", new String[0]);
    protected static final ParseField SOURCE_FIELD = new ParseField("source", new String[0]);
    protected static final ParseField TIME_IN_QUEUE_MILLIS_FIELD = new ParseField("time_in_queue_millis", new String[0]);
    protected static final ParseField EXECUTING_FIELD = new ParseField("executing", new String[0]);
    protected static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    protected static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    protected static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    protected static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    protected static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    protected static final ParseField PRIMARY_FIELD = new ParseField("primary", new String[0]);
    protected static final ParseField NODE_FIELD = new ParseField("node", new String[0]);
    protected static final ParseField RELOCATING_NODE_FIELD = new ParseField("relocating_node", new String[0]);
    protected static final ParseField EXPECTED_SHARD_SIZE_IN_BYTES_FIELD = new ParseField("expected_shard_size_in_bytes", new String[0]);
    protected static final ParseField ROUTING_FIELD = new ParseField("routing", new String[0]);
    protected static final ParseField FULL_NAME_FIELD = new ParseField("full_name", new String[0]);
    protected static final ParseField MAPPING_FIELD = new ParseField("mapping", new String[0]);
    protected static final ParseField UNASSIGNED_INFO_FIELD = new ParseField("unassigned_info", new String[0]);
    protected static final ParseField ALLOCATION_ID_FIELD = new ParseField("allocation_id", new String[0]);
    protected static final ParseField RECOVERY_SOURCE_FIELD = new ParseField("recovery_source", new String[0]);
    protected static final ParseField AT_FIELD = new ParseField("at", new String[0]);
    protected static final ParseField FAILED_ATTEMPTS_FIELD = new ParseField("failed_attempts", new String[0]);
    protected static final ParseField ALLOCATION_STATUS_FIELD = new ParseField("allocation_status", new String[0]);
    protected static final ParseField DELAYED_FIELD = new ParseField("delayed", new String[0]);
    protected static final Function<String, CurlRequest> GET = Curl::get;
    protected static final Function<String, CurlRequest> POST = Curl::post;
    protected static final Function<String, CurlRequest> PUT = Curl::put;
    protected static final Function<String, CurlRequest> DELETE = Curl::delete;
    protected static final Function<String, CurlRequest> HEAD = Curl::head;
    protected final HttpClient client;

    public HttpAction(HttpClient client) {
        this.client = client;
    }

    protected XContentParser createParser(CurlResponse response) throws IOException {
        String contentType = response.getHeaderValue("Content-Type");
        MediaType mediaType = HttpAction.fromMediaTypeOrFormat(contentType);
        XContent xContent = mediaType.xContent();
        return xContent.createParser(this.client.getNamedXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getContentAsStream());
    }

    protected OpenSearchStatusException toOpenSearchException(CurlResponse response, Throwable t) {
        OpenSearchStatusException fesenException;
        try (XContentParser parser = this.createParser(response);){
            fesenException = BytesRestResponse.errorFromXContent((XContentParser)parser);
            fesenException.addSuppressed(t);
            fesenException.addSuppressed((Throwable)new CurlResponseException(response.getContentAsString()));
        }
        catch (Exception ex) {
            fesenException = new OpenSearchStatusException(response.getContentAsString(), RestStatus.fromCode((int)response.getHttpStatusCode()), t, new Object[0]);
            fesenException.addSuppressed(t);
            fesenException.addSuppressed((Throwable)ex);
        }
        return fesenException;
    }

    protected <T> void unwrapOpenSearchException(ActionListener<T> listener, Exception e) {
        if (e.getCause() instanceof OpenSearchException) {
            listener.onFailure((Exception)((OpenSearchException)e.getCause()));
        } else {
            listener.onFailure(e);
        }
    }

    protected int getActiveShardsCountValue(ActiveShardCount activeShardCount) {
        int n;
        ByteArrayStreamOutput out = new ByteArrayStreamOutput();
        try {
            activeShardCount.writeTo((StreamOutput)out);
            n = out.toStreamInput().readInt();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OpenSearchException("Failed to parse a request.", (Throwable)e, new Object[0]);
            }
        }
        out.close();
        return n;
    }

    protected static MediaType fromMediaTypeOrFormat(String mediaType) {
        if (mediaType != null) {
            for (XContentType type : XContentType.values()) {
                if (!HttpAction.isSameMediaTypeOrFormatAs(mediaType, type)) continue;
                return type;
            }
        }
        return XContentType.JSON;
    }

    private static boolean isSameMediaTypeOrFormatAs(String stringType, XContentType type) {
        return type.mediaTypeWithoutParameters().equalsIgnoreCase(stringType) || stringType.toLowerCase(Locale.ROOT).startsWith(type.mediaTypeWithoutParameters().toLowerCase(Locale.ROOT) + ";") || type.subtype().equalsIgnoreCase(stringType);
    }

    protected static class CurlResponseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CurlResponseException(String msg) {
            super(msg, null, false, false);
        }
    }
}

