/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.EngineInfo;
import org.codelibs.fesen.client.HttpAbstractClient;
import org.codelibs.fesen.client.HttpAdminClient;
import org.codelibs.fesen.client.action.HttpAnalyzeAction;
import org.codelibs.fesen.client.action.HttpBulkAction;
import org.codelibs.fesen.client.action.HttpCancelTasksAction;
import org.codelibs.fesen.client.action.HttpClearIndicesCacheAction;
import org.codelibs.fesen.client.action.HttpClearScrollAction;
import org.codelibs.fesen.client.action.HttpCloseIndexAction;
import org.codelibs.fesen.client.action.HttpClusterHealthAction;
import org.codelibs.fesen.client.action.HttpClusterRerouteAction;
import org.codelibs.fesen.client.action.HttpClusterUpdateSettingsAction;
import org.codelibs.fesen.client.action.HttpCreateIndexAction;
import org.codelibs.fesen.client.action.HttpCreateSnapshotAction;
import org.codelibs.fesen.client.action.HttpDeleteAction;
import org.codelibs.fesen.client.action.HttpDeleteIndexAction;
import org.codelibs.fesen.client.action.HttpDeleteIndexTemplateAction;
import org.codelibs.fesen.client.action.HttpDeletePipelineAction;
import org.codelibs.fesen.client.action.HttpDeleteRepositoryAction;
import org.codelibs.fesen.client.action.HttpDeleteSnapshotAction;
import org.codelibs.fesen.client.action.HttpDeleteStoredScriptAction;
import org.codelibs.fesen.client.action.HttpExplainAction;
import org.codelibs.fesen.client.action.HttpFieldCapabilitiesAction;
import org.codelibs.fesen.client.action.HttpFlushAction;
import org.codelibs.fesen.client.action.HttpForceMergeAction;
import org.codelibs.fesen.client.action.HttpGetAction;
import org.codelibs.fesen.client.action.HttpGetAliasesAction;
import org.codelibs.fesen.client.action.HttpGetFieldMappingsAction;
import org.codelibs.fesen.client.action.HttpGetIndexAction;
import org.codelibs.fesen.client.action.HttpGetIndexTemplatesAction;
import org.codelibs.fesen.client.action.HttpGetMappingsAction;
import org.codelibs.fesen.client.action.HttpGetPipelineAction;
import org.codelibs.fesen.client.action.HttpGetRepositoriesAction;
import org.codelibs.fesen.client.action.HttpGetSettingsAction;
import org.codelibs.fesen.client.action.HttpGetSnapshotsAction;
import org.codelibs.fesen.client.action.HttpGetStoredScriptAction;
import org.codelibs.fesen.client.action.HttpIndexAction;
import org.codelibs.fesen.client.action.HttpIndicesAliasesAction;
import org.codelibs.fesen.client.action.HttpIndicesExistsAction;
import org.codelibs.fesen.client.action.HttpListTasksAction;
import org.codelibs.fesen.client.action.HttpMainAction;
import org.codelibs.fesen.client.action.HttpMultiGetAction;
import org.codelibs.fesen.client.action.HttpMultiSearchAction;
import org.codelibs.fesen.client.action.HttpNodesHotThreadsAction;
import org.codelibs.fesen.client.action.HttpNodesStatsAction;
import org.codelibs.fesen.client.action.HttpOpenIndexAction;
import org.codelibs.fesen.client.action.HttpPendingClusterTasksAction;
import org.codelibs.fesen.client.action.HttpPutIndexTemplateAction;
import org.codelibs.fesen.client.action.HttpPutMappingAction;
import org.codelibs.fesen.client.action.HttpPutPipelineAction;
import org.codelibs.fesen.client.action.HttpPutRepositoryAction;
import org.codelibs.fesen.client.action.HttpPutStoredScriptAction;
import org.codelibs.fesen.client.action.HttpRefreshAction;
import org.codelibs.fesen.client.action.HttpRestoreSnapshotAction;
import org.codelibs.fesen.client.action.HttpRolloverAction;
import org.codelibs.fesen.client.action.HttpSearchAction;
import org.codelibs.fesen.client.action.HttpSearchScrollAction;
import org.codelibs.fesen.client.action.HttpSimulatePipelineAction;
import org.codelibs.fesen.client.action.HttpSnapshotsStatusAction;
import org.codelibs.fesen.client.action.HttpUpdateAction;
import org.codelibs.fesen.client.action.HttpUpdateSettingsAction;
import org.codelibs.fesen.client.action.HttpValidateQueryAction;
import org.codelibs.fesen.client.action.HttpVerifyRepositoryAction;
import org.codelibs.fesen.client.curl.FesenRequest;
import org.codelibs.fesen.client.node.NodeManager;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsAction;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.opensearch.action.admin.cluster.repositories.verify.VerifyRepositoryAction;
import org.opensearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.opensearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusAction;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.opensearch.action.admin.cluster.storedscripts.DeleteStoredScriptAction;
import org.opensearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptAction;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.opensearch.action.admin.cluster.storedscripts.PutStoredScriptAction;
import org.opensearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.opensearch.action.admin.indices.alias.IndicesAliasesAction;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesAction;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.opensearch.action.admin.indices.close.CloseIndexAction;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.opensearch.action.admin.indices.create.CreateIndexAction;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexAction;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.flush.FlushAction;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.action.admin.indices.get.GetIndexAction;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingAction;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.open.OpenIndexAction;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshAction;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.rollover.RolloverAction;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsAction;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteAction;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.explain.ExplainAction;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.fieldcaps.FieldCapabilitiesAction;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.opensearch.action.get.GetAction;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetAction;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexAction;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.ingest.DeletePipelineAction;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.ingest.GetPipelineAction;
import org.opensearch.action.ingest.GetPipelineRequest;
import org.opensearch.action.ingest.GetPipelineResponse;
import org.opensearch.action.ingest.PutPipelineAction;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.action.ingest.SimulatePipelineAction;
import org.opensearch.action.ingest.SimulatePipelineRequest;
import org.opensearch.action.ingest.SimulatePipelineResponse;
import org.opensearch.action.main.MainAction;
import org.opensearch.action.main.MainRequest;
import org.opensearch.action.main.MainResponse;
import org.opensearch.action.search.ClearScrollAction;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.MultiSearchAction;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollAction;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.AdminClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.plugins.spi.NamedXContentProvider;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.opensearch.search.aggregations.bucket.composite.ParsedComposite;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilter;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilters;
import org.opensearch.search.aggregations.bucket.global.ParsedGlobal;
import org.opensearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.opensearch.search.aggregations.bucket.missing.ParsedMissing;
import org.opensearch.search.aggregations.bucket.nested.ParsedNested;
import org.opensearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.opensearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.opensearch.search.aggregations.bucket.range.ParsedDateRange;
import org.opensearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.opensearch.search.aggregations.bucket.range.ParsedRange;
import org.opensearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.opensearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.opensearch.search.aggregations.metrics.ParsedAvg;
import org.opensearch.search.aggregations.metrics.ParsedCardinality;
import org.opensearch.search.aggregations.metrics.ParsedExtendedStats;
import org.opensearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedMax;
import org.opensearch.search.aggregations.metrics.ParsedMin;
import org.opensearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.opensearch.search.aggregations.metrics.ParsedStats;
import org.opensearch.search.aggregations.metrics.ParsedSum;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedTopHits;
import org.opensearch.search.aggregations.metrics.ParsedValueCount;
import org.opensearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.opensearch.search.aggregations.pipeline.ParsedDerivative;
import org.opensearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.opensearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.opensearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.opensearch.search.aggregations.pipeline.ParsedStatsBucket;
import org.opensearch.threadpool.ThreadPool;

public class HttpClient
extends HttpAbstractClient {
    protected static final Function<String, CurlRequest> GET = Curl::get;
    protected static final Function<String, CurlRequest> POST = Curl::post;
    protected static final Function<String, CurlRequest> PUT = Curl::put;
    protected static final Function<String, CurlRequest> DELETE = Curl::delete;
    protected static final Function<String, CurlRequest> HEAD = Curl::head;
    protected NodeManager nodeManager;
    protected final Map<ActionType<?>, BiConsumer<ActionRequest, ActionListener<?>>> actions = new HashMap();
    protected final NamedXContentRegistry namedXContentRegistry;
    protected final ForkJoinPool threadPool;
    protected final String basicAuth;
    private final SSLSocketFactory sslSocketFactory;
    protected final boolean compression;
    protected final Proxy proxy;
    protected final String proxyAuth;
    protected final List<UnaryOperator<CurlRequest>> requestBuilderList = new ArrayList<UnaryOperator<CurlRequest>>();
    private EngineInfo engineInfo;

    public HttpClient(Settings settings, ThreadPool threadPool) {
        this(settings, threadPool, Collections.emptyList());
    }

    public HttpClient(Settings settings, ThreadPool threadPool, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(settings, threadPool);
        String[] hosts = (String[])settings.getAsList("http.hosts").stream().map(s -> {
            if (!s.startsWith("http:") && !s.startsWith("https:")) {
                return "http://" + s;
            }
            return s;
        }).toArray(String[]::new);
        if (hosts.length == 0) {
            throw new OpenSearchException("http.hosts is empty.", new Object[0]);
        }
        this.nodeManager = new NodeManager(hosts, this);
        this.nodeManager.setHeartbeatInterval(settings.getAsLong("http.heartbeat_interval", Long.valueOf(10000L)));
        this.compression = settings.getAsBoolean("http.compression", Boolean.valueOf(true));
        this.basicAuth = this.createBasicAuthentication(settings);
        this.sslSocketFactory = this.createSSLSocketFactory(settings);
        this.proxy = this.createProxy(settings);
        this.proxyAuth = this.createProxyAuthentication(settings);
        this.threadPool = this.createThreadPool(settings);
        this.namedXContentRegistry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream(), this.getProvidedNamedXContents().stream(), namedXContentEntries.stream()).flatMap(Function.identity()).collect(Collectors.toList()));
        this.actions.put((ActionType<?>)SearchAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpSearchAction(this, SearchAction.INSTANCE).execute((SearchRequest)request, (ActionListener<SearchResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)RefreshAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpRefreshAction(this, RefreshAction.INSTANCE).execute((RefreshRequest)request, (ActionListener<RefreshResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)CreateIndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpCreateIndexAction(this, CreateIndexAction.INSTANCE).execute((CreateIndexRequest)request, (ActionListener<CreateIndexResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteIndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteIndexAction(this, DeleteIndexAction.INSTANCE).execute((DeleteIndexRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetIndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetIndexAction(this, GetIndexAction.INSTANCE).execute((GetIndexRequest)request, (ActionListener<GetIndexResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)OpenIndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpOpenIndexAction(this, OpenIndexAction.INSTANCE).execute((OpenIndexRequest)request, (ActionListener<OpenIndexResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)CloseIndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpCloseIndexAction(this, CloseIndexAction.INSTANCE).execute((CloseIndexRequest)request, (ActionListener<CloseIndexResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)IndicesExistsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpIndicesExistsAction(this, IndicesExistsAction.INSTANCE).execute((IndicesExistsRequest)request, (ActionListener<IndicesExistsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)IndicesAliasesAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpIndicesAliasesAction(this, IndicesAliasesAction.INSTANCE).execute((IndicesAliasesRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PutMappingAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPutMappingAction(this, PutMappingAction.INSTANCE).execute((PutMappingRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetMappingsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetMappingsAction(this, GetMappingsAction.INSTANCE).execute((GetMappingsRequest)request, (ActionListener<GetMappingsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetFieldMappingsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetFieldMappingsAction(this, GetFieldMappingsAction.INSTANCE).execute((GetFieldMappingsRequest)request, (ActionListener<GetFieldMappingsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)FlushAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpFlushAction(this, FlushAction.INSTANCE).execute((FlushRequest)request, (ActionListener<FlushResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ClearScrollAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpClearScrollAction(this, ClearScrollAction.INSTANCE).execute((ClearScrollRequest)request, (ActionListener<ClearScrollResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)MultiSearchAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpMultiSearchAction(this, MultiSearchAction.INSTANCE).execute((MultiSearchRequest)request, (ActionListener<MultiSearchResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)SearchScrollAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpSearchScrollAction(this, SearchScrollAction.INSTANCE).execute((SearchScrollRequest)request, (ActionListener<SearchResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)IndexAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpIndexAction(this, IndexAction.INSTANCE).execute((IndexRequest)request, (ActionListener<IndexResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)FieldCapabilitiesAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpFieldCapabilitiesAction(this, FieldCapabilitiesAction.INSTANCE).execute((FieldCapabilitiesRequest)request, (ActionListener<FieldCapabilitiesResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetAction(this, GetAction.INSTANCE).execute((GetRequest)request, (ActionListener<GetResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)MultiGetAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpMultiGetAction(this, MultiGetAction.INSTANCE).execute((MultiGetRequest)request, (ActionListener<MultiGetResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)UpdateAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpUpdateAction(this, UpdateAction.INSTANCE).execute((UpdateRequest)request, (ActionListener<UpdateResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)BulkAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpBulkAction(this, BulkAction.INSTANCE).execute((BulkRequest)request, (ActionListener<BulkResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteAction(this, DeleteAction.INSTANCE).execute((DeleteRequest)request, (ActionListener<DeleteResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ExplainAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpExplainAction(this, ExplainAction.INSTANCE).execute((ExplainRequest)request, (ActionListener<ExplainResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)UpdateSettingsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpUpdateSettingsAction(this, UpdateSettingsAction.INSTANCE).execute((UpdateSettingsRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetSettingsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetSettingsAction(this, GetSettingsAction.INSTANCE).execute((GetSettingsRequest)request, (ActionListener<GetSettingsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ForceMergeAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpForceMergeAction(this, ForceMergeAction.INSTANCE).execute((ForceMergeRequest)request, (ActionListener<ForceMergeResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)MainAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpMainAction(this, MainAction.INSTANCE).execute((MainRequest)request, (ActionListener<MainResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ClusterUpdateSettingsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpClusterUpdateSettingsAction(this, ClusterUpdateSettingsAction.INSTANCE).execute((ClusterUpdateSettingsRequest)request, (ActionListener<ClusterUpdateSettingsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ClusterHealthAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpClusterHealthAction(this, ClusterHealthAction.INSTANCE).execute((ClusterHealthRequest)request, (ActionListener<ClusterHealthResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ValidateQueryAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpValidateQueryAction(this, ValidateQueryAction.INSTANCE).execute((ValidateQueryRequest)request, (ActionListener<ValidateQueryResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PendingClusterTasksAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPendingClusterTasksAction(this, PendingClusterTasksAction.INSTANCE).execute((PendingClusterTasksRequest)request, (ActionListener<PendingClusterTasksResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetAliasesAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetAliasesAction(this, GetAliasesAction.INSTANCE).execute((GetAliasesRequest)request, (ActionListener<GetAliasesResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)RolloverAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpRolloverAction(this, RolloverAction.INSTANCE).execute((RolloverRequest)request, (ActionListener<RolloverResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ClearIndicesCacheAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpClearIndicesCacheAction(this, ClearIndicesCacheAction.INSTANCE).execute((ClearIndicesCacheRequest)request, (ActionListener<ClearIndicesCacheResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PutPipelineAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPutPipelineAction(this, PutPipelineAction.INSTANCE).execute((PutPipelineRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetPipelineAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetPipelineAction(this, GetPipelineAction.INSTANCE).execute((GetPipelineRequest)request, (ActionListener<GetPipelineResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeletePipelineAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeletePipelineAction(this, DeletePipelineAction.INSTANCE).execute((DeletePipelineRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PutStoredScriptAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPutStoredScriptAction(this, PutStoredScriptAction.INSTANCE).execute((PutStoredScriptRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetStoredScriptAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetStoredScriptAction(this, GetStoredScriptAction.INSTANCE).execute((GetStoredScriptRequest)request, (ActionListener<GetStoredScriptResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteStoredScriptAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteStoredScriptAction(this, DeleteStoredScriptAction.INSTANCE).execute((DeleteStoredScriptRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PutIndexTemplateAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPutIndexTemplateAction(this, PutIndexTemplateAction.INSTANCE).execute((PutIndexTemplateRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetIndexTemplatesAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetIndexTemplatesAction(this, GetIndexTemplatesAction.INSTANCE).execute((GetIndexTemplatesRequest)request, (ActionListener<GetIndexTemplatesResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteIndexTemplateAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteIndexTemplateAction(this, DeleteIndexTemplateAction.INSTANCE).execute((DeleteIndexTemplateRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)CancelTasksAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpCancelTasksAction(this, CancelTasksAction.INSTANCE).execute((CancelTasksRequest)request, (ActionListener<CancelTasksResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ListTasksAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpListTasksAction(this, ListTasksAction.INSTANCE).execute((ListTasksRequest)request, (ActionListener<ListTasksResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)VerifyRepositoryAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpVerifyRepositoryAction(this, VerifyRepositoryAction.INSTANCE).execute((VerifyRepositoryRequest)request, (ActionListener<VerifyRepositoryResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)PutRepositoryAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpPutRepositoryAction(this, PutRepositoryAction.INSTANCE).execute((PutRepositoryRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetRepositoriesAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetRepositoriesAction(this, GetRepositoriesAction.INSTANCE).execute((GetRepositoriesRequest)request, (ActionListener<GetRepositoriesResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteRepositoryAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteRepositoryAction(this, DeleteRepositoryAction.INSTANCE).execute((DeleteRepositoryRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)AnalyzeAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpAnalyzeAction(this, AnalyzeAction.INSTANCE).execute((AnalyzeAction.Request)request, (ActionListener<AnalyzeAction.Response>)actionListener);
        }));
        this.actions.put((ActionType<?>)SimulatePipelineAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpSimulatePipelineAction(this, SimulatePipelineAction.INSTANCE).execute((SimulatePipelineRequest)request, (ActionListener<SimulatePipelineResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)SnapshotsStatusAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpSnapshotsStatusAction(this, SnapshotsStatusAction.INSTANCE).execute((SnapshotsStatusRequest)request, (ActionListener<SnapshotsStatusResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)CreateSnapshotAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpCreateSnapshotAction(this, CreateSnapshotAction.INSTANCE).execute((CreateSnapshotRequest)request, (ActionListener<CreateSnapshotResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)GetSnapshotsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpGetSnapshotsAction(this, GetSnapshotsAction.INSTANCE).execute((GetSnapshotsRequest)request, (ActionListener<GetSnapshotsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)DeleteSnapshotAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpDeleteSnapshotAction(this, DeleteSnapshotAction.INSTANCE).execute((DeleteSnapshotRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)ClusterRerouteAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpClusterRerouteAction(this, ClusterRerouteAction.INSTANCE).execute((ClusterRerouteRequest)request, (ActionListener<AcknowledgedResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)RestoreSnapshotAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpRestoreSnapshotAction(this, RestoreSnapshotAction.INSTANCE).execute((RestoreSnapshotRequest)request, (ActionListener<RestoreSnapshotResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)NodesStatsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpNodesStatsAction(this, NodesStatsAction.INSTANCE).execute((NodesStatsRequest)request, (ActionListener<NodesStatsResponse>)actionListener);
        }));
        this.actions.put((ActionType<?>)NodesHotThreadsAction.INSTANCE, (BiConsumer<ActionRequest, ActionListener<?>>)((BiConsumer<ActionRequest, ActionListener>)(request, listener) -> {
            ActionListener actionListener = listener;
            new HttpNodesHotThreadsAction(this, NodesHotThreadsAction.INSTANCE).execute((NodesHotThreadsRequest)request, (ActionListener<NodesHotThreadsResponse>)actionListener);
        }));
    }

    @Override
    public AdminClient admin() {
        return new HttpAdminClient(super.admin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EngineInfo getEngineInfo() {
        if (this.engineInfo != null) {
            return this.engineInfo;
        }
        HttpClient httpClient = this;
        synchronized (httpClient) {
            if (this.engineInfo != null) {
                return this.engineInfo;
            }
            try (CurlResponse response = this.getCurlRequest(Curl::get, "/", new String[0]).execute();){
                if (response.getHttpStatusCode() == 200) {
                    Map content = (Map)response.getContent(res -> {
                        Map map;
                        block8: {
                            InputStream is = res.getContentAsStream();
                            try {
                                map = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, is).map();
                                if (is == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    throw new CurlException("Failed to access the content.", (Throwable)e);
                                }
                            }
                            is.close();
                        }
                        return map;
                    });
                    EngineInfo engineInfo = this.engineInfo = new EngineInfo(content);
                    return engineInfo;
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to access status.", (Throwable)e);
            }
            throw new OpenSearchException("Unknown server info: {}", new Object[]{this.nodeManager.toNodeString()});
        }
    }

    protected String createBasicAuthentication(Settings settings) {
        String username = settings.get("fesen.username");
        String password = settings.get("fesen.password");
        if (username != null && password != null) {
            String value = username + ":" + password;
            return "Basic " + Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    protected SSLSocketFactory createSSLSocketFactory(Settings settings) {
        SSLSocketFactory sSLSocketFactory;
        String certificateAuthorities = settings.get("http.ssl.certificate_authorities");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("http.ssl.certificate_authorities: {}", (Object)certificateAuthorities);
        }
        if (certificateAuthorities == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(certificateAuthorities);
        try {
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(in);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("server", certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            sSLSocketFactory = sslContext.getSocketFactory();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.warn("Failed to load {}", (Object)certificateAuthorities, (Object)e);
                return null;
            }
        }
        ((InputStream)in).close();
        return sSLSocketFactory;
    }

    protected Proxy createProxy(Settings settings) {
        String host = this.getFromSettings(settings, "https.proxy_host", "http.proxy_host");
        String port = this.getFromSettings(settings, "https.proxy_port", "http.proxy_port");
        if (host != null && port != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port)));
        }
        return null;
    }

    protected String createProxyAuthentication(Settings settings) {
        String username = this.getFromSettings(settings, "https.proxy_username", "http.proxy_username");
        String password = this.getFromSettings(settings, "https.proxy_password", "http.proxy_password");
        if (username != null && password != null) {
            String value = username + ":" + password;
            return "Basic " + Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    protected String getFromSettings(Settings settings, String key1, String key2) {
        String value1 = settings.get(key1);
        if (value1 != null) {
            return value1;
        }
        return settings.get(key2);
    }

    public void close() {
        try {
            this.nodeManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.threadPool.isShutdown()) {
            try {
                this.threadPool.shutdown();
                this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.threadPool.shutdownNow();
            }
        }
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        BiConsumer<ActionRequest, ActionListener<?>> httpAction = this.actions.get(action);
        if (httpAction == null) {
            throw new UnsupportedOperationException("Action: " + action.name());
        }
        httpAction.accept(request, listener);
    }

    public CurlRequest getCurlRequest(Function<String, CurlRequest> method, String path, String ... indices) {
        return this.getCurlRequest(method, ContentType.JSON, path, indices);
    }

    public CurlRequest getCurlRequest(Function<String, CurlRequest> method, ContentType contentType, String path, String ... indices) {
        return this.getPlainCurlRequest(s -> new FesenRequest((CurlRequest)method.apply(null), this.nodeManager, (String)s), contentType, path, indices);
    }

    public CurlRequest getPlainCurlRequest(Function<String, CurlRequest> requestCreator, ContentType contentType, String path, String ... indices) {
        StringBuilder buf = new StringBuilder(100);
        if (indices.length > 0) {
            buf.append('/').append(UrlUtils.joinAndEncode(",", indices));
        }
        if (path != null) {
            buf.append(path);
        }
        CurlRequest request = requestCreator.apply(buf.toString()).header("Content-Type", contentType.getString()).threadPool(this.threadPool);
        if (this.basicAuth != null) {
            request.header("Authorization", this.basicAuth);
        }
        if (this.sslSocketFactory != null) {
            request.sslSocketFactory(this.sslSocketFactory);
        }
        if (this.compression) {
            request.compression("gzip");
        }
        if (this.proxy != null) {
            request.proxy(this.proxy);
            if (this.proxyAuth != null) {
                request.header("Proxy-Authorization", this.proxyAuth);
            }
        }
        for (UnaryOperator<CurlRequest> builder : this.requestBuilderList) {
            request = (CurlRequest)builder.apply(request);
        }
        return request;
    }

    protected ForkJoinPool createThreadPool(Settings settings) {
        int parallelism = settings.getAsInt("thread_pool.http.size", settings.getAsInt("processors", Integer.valueOf(Runtime.getRuntime().availableProcessors())));
        boolean asyncMode = settings.getAsBoolean("thread_pool.http.async", Boolean.valueOf(false));
        return new ForkJoinPool(parallelism, WorkerThread::new, (t, e) -> this.logger.warn("An exception has been raised by {}", (Object)t.getName(), (Object)e), asyncMode);
    }

    protected List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        return map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).toList();
    }

    protected List<NamedXContentRegistry.Entry> getProvidedNamedXContents() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        for (NamedXContentProvider service : ServiceLoader.load(NamedXContentProvider.class)) {
            entries.addAll(service.getNamedXContentParsers());
        }
        return entries;
    }

    public NamedXContentRegistry getNamedXContentRegistry() {
        return this.namedXContentRegistry;
    }

    public void addRequestBuilder(UnaryOperator<CurlRequest> builder) {
        this.requestBuilderList.add(builder);
    }

    public static enum ContentType {
        JSON("application/json"),
        X_NDJSON("application/x-ndjson");

        private final String value;

        private ContentType(String value) {
            this.value = value;
        }

        public String getString() {
            return this.value;
        }
    }

    protected static class WorkerThread
    extends ForkJoinWorkerThread {
        protected WorkerThread(ForkJoinPool pool) {
            super(pool);
            this.setName("eshttp");
        }
    }
}

