/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

public final class SDo
extends AStatement {
    private final SBlock block;
    private AExpression condition;
    private boolean continuous = false;

    public SDo(Location location, SBlock block, AExpression condition) {
        super(location);
        this.condition = Objects.requireNonNull(condition);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.condition.extractVariables(variables);
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        locals = Locals.newLocalScope(locals);
        if (this.block == null) {
            throw this.createError(new IllegalArgumentException("Extraneous do while loop."));
        }
        this.block.beginLoop = true;
        this.block.inLoop = true;
        this.block.analyze(locals);
        if (this.block.loopEscape && !this.block.anyContinue) {
            throw this.createError(new IllegalArgumentException("Extraneous do while loop."));
        }
        this.condition.expected = Definition.BOOLEAN_TYPE;
        this.condition.analyze(locals);
        this.condition = this.condition.cast(locals);
        if (this.condition.constant != null) {
            this.continuous = (Boolean)this.condition.constant;
            if (!this.continuous) {
                throw this.createError(new IllegalArgumentException("Extraneous do while loop."));
            }
            if (!this.block.anyBreak) {
                this.methodEscape = true;
                this.allEscape = true;
            }
        }
        this.statementCount = 1;
        if (locals.hasVariable("#loop")) {
            this.loopCounter = locals.getVariable(this.location, "#loop");
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label start = new Label();
        Label begin = new Label();
        Label end = new Label();
        writer.mark(start);
        this.block.continu = begin;
        this.block.brake = end;
        this.block.write(writer, globals);
        writer.mark(begin);
        if (!this.continuous) {
            this.condition.write(writer, globals);
            writer.ifZCmp(153, end);
        }
        if (this.loopCounter != null) {
            writer.writeLoopCounter(this.loopCounter.getSlot(), Math.max(1, this.block.statementCount), this.location);
        }
        writer.goTo(start);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.condition, this.block);
    }
}

