/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.EStatic;
import org.elasticsearch.painless.node.PSubCallInvoke;
import org.elasticsearch.painless.node.PSubDefCall;
import org.elasticsearch.painless.node.PSubNullSafeCallInvoke;

public final class PCallInvoke
extends AExpression {
    private final String name;
    private final boolean nullSafe;
    private final List<AExpression> arguments;
    private AExpression sub = null;

    public PCallInvoke(Location location, AExpression prefix, String name, boolean nullSafe, List<AExpression> arguments) {
        super(location, prefix);
        this.name = Objects.requireNonNull(name);
        this.nullSafe = nullSafe;
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.prefix.extractVariables(variables);
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Definition.Method method;
        this.prefix.analyze(locals);
        this.prefix.expected = this.prefix.actual;
        this.prefix = this.prefix.cast(locals);
        if (this.prefix.actual.sort == Definition.Sort.ARRAY) {
            throw this.createError(new IllegalArgumentException("Illegal call [" + this.name + "] on array type."));
        }
        Definition.Struct struct = this.prefix.actual.struct;
        if (this.prefix.actual.sort.primitive) {
            struct = Definition.getType((String)this.prefix.actual.sort.boxed.getSimpleName()).struct;
        }
        Definition.MethodKey methodKey = new Definition.MethodKey(this.name, this.arguments.size());
        Definition.Method method2 = method = this.prefix instanceof EStatic ? struct.staticMethods.get(methodKey) : struct.methods.get(methodKey);
        if (method != null) {
            this.sub = new PSubCallInvoke(this.location, method, this.prefix.actual, this.arguments);
        } else if (this.prefix.actual.sort == Definition.Sort.DEF) {
            this.sub = new PSubDefCall(this.location, this.name, this.arguments);
        } else {
            throw this.createError(new IllegalArgumentException("Unknown call [" + this.name + "] with [" + this.arguments.size() + "] arguments on type [" + struct.name + "]."));
        }
        if (this.nullSafe) {
            this.sub = new PSubNullSafeCallInvoke(this.location, this.sub);
        }
        this.sub.expected = this.expected;
        this.sub.explicit = this.explicit;
        this.sub.analyze(locals);
        this.actual = this.sub.actual;
        this.statement = true;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.prefix.write(writer, globals);
        this.sub.write(writer, globals);
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.prefix, this.name);
    }
}

