/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.util.river;

import org.codelibs.elasticsearch.util.exception.EsUtilSystemException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.river.RiverName;

public final class RiverUtils {
    private RiverUtils() {
    }

    public static void deleteQuietly(Client client, RiverName riverName) {
        try {
            RiverUtils.delete(client, riverName);
        }
        catch (EsUtilSystemException esUtilSystemException) {
            // empty catch block
        }
    }

    public static void delete(Client client, RiverName riverName) {
        DeleteMappingResponse deleteMappingResponse;
        try {
            deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
        }
        catch (ElasticsearchException e) {
            throw new EsUtilSystemException("Failed to delete " + riverName.name(), e);
        }
        if (!deleteMappingResponse.isAcknowledged()) {
            throw new EsUtilSystemException("Failed to delete " + riverName.name() + ". " + deleteMappingResponse.toString());
        }
    }
}

