/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncAction;
import org.codelibs.elasticsearch.configsync.service.ConfigSyncService;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.sort.SortOrder;

public class RestConfigSyncFileAction
extends RestConfigSyncAction {
    private final ConfigSyncService configSyncService;

    @Inject
    public RestConfigSyncFileAction(Settings settings, RestController controller, ConfigSyncService configSyncService) {
        this.configSyncService = configSyncService;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_configsync/file"), new RestHandler.Route(RestRequest.Method.POST, "/_configsync/file"), new RestHandler.Route(RestRequest.Method.DELETE, "/_configsync/file")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try {
            BytesReference content = request.content();
            switch (request.method()) {
                case GET: {
                    String path;
                    if (request.param("path") != null) {
                        path = request.param("path");
                    } else if (content != null && content.length() > 0) {
                        Map sourceAsMap = Source.fromBytes((BytesReference)content).source();
                        path = (String)sourceAsMap.get("path");
                    } else {
                        path = null;
                    }
                    if (path == null) {
                        String sortOrder;
                        String sortField;
                        String[] sortValues = request.param("sort", "path").split(":");
                        if (sortValues.length > 1) {
                            sortField = sortValues[0];
                            sortOrder = sortValues[1];
                        } else {
                            sortField = sortValues[0];
                            sortOrder = SortOrder.ASC.toString();
                        }
                        String[] fields = request.paramAsStringArrayOrEmptyIfAll("fields");
                        int from = request.paramAsInt("from", 0);
                        int size = request.paramAsInt("size", 10);
                        return channel -> this.configSyncService.getPaths(from, size, fields, sortField, sortOrder, (ActionListener<List<Object>>)ActionListener.wrap(response -> {
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put(fields.length == 0 ? "path" : "file", response);
                            this.sendResponse((RestChannel)channel, (Map<String, Object>)params);
                        }, e -> this.sendErrorResponse((RestChannel)channel, (Exception)e)));
                    }
                    return channel -> this.configSyncService.getContent(path, (ActionListener<byte[]>)ActionListener.wrap(configContent -> {
                        if (configContent != null) {
                            channel.sendResponse(new RestResponse(RestStatus.OK, "application/octet-stream", (BytesReference)new BytesArray(configContent)));
                        } else {
                            channel.sendResponse(new RestResponse(RestStatus.NOT_FOUND, path + " is not found."));
                        }
                    }, e -> this.sendErrorResponse((RestChannel)channel, (Exception)e)));
                }
                case POST: {
                    byte[] contentArray;
                    String path;
                    if (content == null) {
                        throw new ElasticsearchException("content is empty.", new Object[0]);
                    }
                    if (request.param("path") != null) {
                        path = request.param("path");
                        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                            content.writeTo((OutputStream)out);
                            contentArray = out.toByteArray();
                        }
                    } else {
                        Map sourceAsMap = Source.fromBytes((BytesReference)content).source();
                        path = (String)sourceAsMap.get("path");
                        String fileContent = (String)sourceAsMap.get("content");
                        contentArray = Base64.getDecoder().decode(fileContent);
                    }
                    return channel -> this.configSyncService.store(path, contentArray, (ActionListener<DocWriteResponse>)ActionListener.wrap(res -> this.sendResponse((RestChannel)channel, null), e -> this.sendErrorResponse((RestChannel)channel, (Exception)e)));
                }
                case DELETE: {
                    String path;
                    if (request.param("path") != null) {
                        path = request.param("path");
                    } else if (content != null && content.length() > 0) {
                        Map sourceAsMap = Source.fromBytes((BytesReference)content).source();
                        path = (String)sourceAsMap.get("path");
                    } else {
                        path = null;
                    }
                    if (path == null) {
                        return channel -> this.sendErrorResponse((RestChannel)channel, (Exception)new ElasticsearchException("path is empty.", new Object[0]));
                    }
                    return channel -> this.configSyncService.delete(path, (ActionListener<DeleteResponse>)ActionListener.wrap(response -> {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("result", response.getResult().toString().toLowerCase());
                        this.sendResponse((RestChannel)channel, (Map<String, Object>)params);
                    }, e -> this.sendErrorResponse((RestChannel)channel, (Exception)e)));
                }
            }
            return channel -> this.sendErrorResponse((RestChannel)channel, (Exception)new ElasticsearchException("Unknown request type.", new Object[0]));
        }
        catch (Exception e) {
            return channel -> this.sendErrorResponse((RestChannel)channel, e);
        }
    }

    public String getName() {
        return "configsync_file_action";
    }
}

