/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.rest;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public abstract class RestConfigSyncAction
extends BaseRestHandler {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    protected void sendResponse(RestChannel channel, Map<String, Object> params) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            builder.field("acknowledged", true);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
            }
            builder.endObject();
            channel.sendResponse(new RestResponse(RestStatus.OK, builder));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create a resposne.", (Throwable)e, new Object[0]);
        }
    }

    protected void sendErrorResponse(RestChannel channel, Exception e) {
        try {
            channel.sendResponse(new RestResponse(channel, e));
        }
        catch (Exception e1) {
            this.logger.error("Failed to send a failure response.", (Throwable)e1);
        }
    }
}

