/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.codelibs.elasticsearch.configsync.action.ConfigResetSyncResponse;
import org.codelibs.elasticsearch.configsync.action.ResetSyncRequest;
import org.codelibs.elasticsearch.configsync.action.ResetSyncResponse;
import org.codelibs.elasticsearch.configsync.service.ConfigSyncService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportResetSyncAction
extends HandledTransportAction<ResetSyncRequest, ResetSyncResponse> {
    private final TransportService transportService;
    private final ConfigSyncService configSyncService;

    @Inject
    public TransportResetSyncAction(TransportService transportService, ActionFilters actionFilters, ConfigSyncService configSyncService) {
        super("cluster:admin/configsync/reset_sync", transportService, actionFilters, ResetSyncRequest::new);
        this.transportService = transportService;
        this.configSyncService = configSyncService;
        configSyncService.setResetSyncAction(this);
    }

    protected void doExecute(Task task, ResetSyncRequest request, ActionListener<ResetSyncResponse> listener) {
        this.configSyncService.restartUpdater((ActionListener<ActionResponse>)ActionListener.wrap(response -> listener.onResponse((Object)new ResetSyncResponse(true)), e -> listener.onFailure(e)));
    }

    public void sendRequest(final Iterator<DiscoveryNode> nodesIt, final ActionListener<ConfigResetSyncResponse> listener) {
        DiscoveryNode node = nodesIt.next();
        this.transportService.sendRequest(node, "cluster:admin/configsync/reset_sync", (TransportRequest)new ResetSyncRequest(), (TransportResponseHandler)new TransportResponseHandler<ResetSyncResponse>(){

            public ResetSyncResponse read(StreamInput in) throws IOException {
                return new ResetSyncResponse(in);
            }

            public void handleResponse(ResetSyncResponse response) {
                TransportResetSyncAction.this.configSyncService.resetSync(nodesIt, (ActionListener<ConfigResetSyncResponse>)listener);
            }

            public void handleException(TransportException exp) {
                listener.onFailure((Exception)exp);
            }

            public Executor executor(ThreadPool threadPool) {
                return threadPool.generic();
            }
        });
    }
}

