/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codelibs.elasticsearch.runner.ClusterRunnerException;
import org.codelibs.elasticsearch.runner.node.ClusterRunnerNode;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequestBuilder;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClusterRunner
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger((String)"codelibs.cluster.runner");
    private static final String NODE_NAME = "node.name";
    protected static final String LOG4J2_PROPERTIES = "log4j2.properties";
    protected static final String ELASTICSEARCH_YAML = "elasticsearch.yml";
    public static String[] MODULE_TYPES = new String[]{"org.elasticsearch.search.aggregations.matrix.MatrixAggregationPlugin", "org.elasticsearch.ingest.common.IngestCommonPlugin", "org.elasticsearch.script.expression.ExpressionPlugin", "org.elasticsearch.script.groovy.GroovyPlugin", "org.elasticsearch.script.mustache.MustachePlugin", "org.elasticsearch.painless.PainlessPlugin", "org.elasticsearch.percolator.PercolatorPlugin", "org.elasticsearch.index.reindex.ReindexPlugin", "org.elasticsearch.transport.Netty3Plugin", "org.elasticsearch.transport.Netty4Plugin"};
    protected static final String DATA_DIR = "data";
    protected static final String LOGS_DIR = "logs";
    protected static final String CONFIG_DIR = "config";
    protected List<Node> nodeList = new ArrayList<Node>();
    protected List<Settings> settingsList = new ArrayList<Settings>();
    protected Collection<Class<? extends Plugin>> pluginList = new ArrayList<Class<? extends Plugin>>();
    protected int maxHttpPort = 9299;
    protected int maxTransportPort = 9399;
    @Option(name="-basePath", usage="Base path for Elasticsearch.")
    protected String basePath;
    @Option(name="-confPath", usage="Config path for Elasticsearch.")
    protected String confPath;
    @Option(name="-dataPath", usage="Data path for Elasticsearch.")
    protected String dataPath;
    @Option(name="-logsPath", usage="Log path for Elasticsearch.")
    protected String logsPath;
    @Option(name="-numOfNode", usage="The number of Elasticsearch node.")
    protected int numOfNode = 3;
    @Option(name="-baseTransportPort", usage="Base transport port.")
    protected int baseTransportPort = 9300;
    @Option(name="-baseHttpPort", usage="Base http port.")
    protected int baseHttpPort = 9200;
    @Option(name="-clusterName", usage="Cluster name.")
    protected String clusterName = "elasticsearch-cluster-runner";
    @Option(name="-indexStoreType", usage="Index store type.")
    protected String indexStoreType = "fs";
    @Option(name="-useLogger", usage="Print logs to a logger.")
    protected boolean useLogger = false;
    @Option(name="-disableESLogger", usage="Disable ESLogger.")
    protected boolean disableESLogger = false;
    @Option(name="-printOnFailure", usage="Print an exception on a failure.")
    protected boolean printOnFailure = false;
    @Option(name="-moduleTypes", usage="Module types.")
    protected String moduleTypes;
    @Option(name="-pluginTypes", usage="Plugin types.")
    protected String pluginTypes;
    protected Builder builder;

    public static void main(String[] args) {
        final ElasticsearchClusterRunner runner = new ElasticsearchClusterRunner();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    runner.close();
                }
                catch (IOException e) {
                    runner.print(e.getLocalizedMessage());
                }
            }
        });
        runner.build(args);
        while (!runner.isClosed()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isClosed() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        ArrayList<IOException> exceptionList = new ArrayList<IOException>();
        for (Node node : this.nodeList) {
            try {
                node.close();
            }
            catch (IOException e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            if (this.useLogger && logger.isDebugEnabled()) {
                for (Exception exception : exceptionList) {
                    logger.debug("Failed to close a node.", (Throwable)exception);
                }
            }
            throw new IOException(((Object)exceptionList).toString());
        }
        this.print("Closed all nodes.");
    }

    public void clean() {
        Path bPath = FileSystems.getDefault().getPath(this.basePath, new String[0]);
        for (int i = 0; i < 3; ++i) {
            try {
                CleanUpFileVisitor visitor = new CleanUpFileVisitor();
                Files.walkFileTree(bPath, visitor);
                if (!visitor.hasErrors()) {
                    this.print("Deleted " + this.basePath);
                    return;
                }
                if (!this.useLogger || !logger.isDebugEnabled()) continue;
                for (Throwable t : visitor.getErrors()) {
                    logger.debug("Could not delete files/directories.", t);
                }
                continue;
            }
            catch (Exception e) {
                this.print(e.getMessage() + " Retring to delete it.");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.print("Failed to delete " + this.basePath + " in this process.");
    }

    public ElasticsearchClusterRunner onBuild(Builder builder) {
        this.builder = builder;
        return this;
    }

    public void build(Configs configs) {
        this.build(configs.build());
    }

    public void build(String ... args) {
        String[] types;
        if (args != null) {
            CmdLineParser parser = new CmdLineParser((Object)this, ParserProperties.defaults().withUsageWidth(80));
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                throw new ClusterRunnerException("Failed to parse args: " + Strings.arrayToDelimitedString((Object[])args, (String)" "));
            }
        }
        if (this.basePath == null) {
            try {
                this.basePath = Files.createTempDirectory("es-cluster", new FileAttribute[0]).toAbsolutePath().toString();
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create $ES_HOME.", e);
            }
        }
        Path esBasePath = Paths.get(this.basePath, new String[0]);
        this.createDir(esBasePath);
        for (String moduleType : types = this.moduleTypes == null ? MODULE_TYPES : this.moduleTypes.split(",")) {
            try {
                Class<Plugin> clazz = Class.forName(moduleType).asSubclass(Plugin.class);
                this.pluginList.add(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.debug(moduleType + " is not found.", (Throwable)e);
            }
        }
        if (this.pluginTypes != null) {
            for (String value : this.pluginTypes.split(",")) {
                String pluginType = value.trim();
                if (pluginType.length() <= 0) continue;
                try {
                    Class<Plugin> clazz = Class.forName(pluginType).asSubclass(Plugin.class);
                    this.pluginList.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new ClusterRunnerException(pluginType + " is not found.", e);
                }
            }
        }
        this.print("----------------------------------------");
        this.print("Cluster Name: " + this.clusterName);
        this.print("Base Path:    " + this.basePath);
        this.print("Num Of Node:  " + this.numOfNode);
        this.print("----------------------------------------");
        for (int i = 0; i < this.numOfNode; ++i) {
            try {
                Settings settings = this.buildNodeSettings(i + 1);
                ClusterRunnerNode node = new ClusterRunnerNode(settings, this.pluginList);
                node.start();
                this.nodeList.add(node);
                this.settingsList.add(settings);
                continue;
            }
            catch (Exception e) {
                throw new ClusterRunnerException("Failed to start node " + (i + 1), e);
            }
        }
    }

    protected Settings buildNodeSettings(int number) throws IOException, UserException {
        String pluginPath;
        Path logConfPath;
        Path homePath = Paths.get(this.basePath, new String[0]);
        Path confPath = this.confPath == null ? Paths.get(this.basePath, CONFIG_DIR, "node_" + number) : Paths.get(this.confPath, new String[0]);
        Path logsPath = this.logsPath == null ? Paths.get(this.basePath, LOGS_DIR, "node_" + number) : Paths.get(this.logsPath, new String[0]);
        Path dataPath = this.dataPath == null ? Paths.get(this.basePath, DATA_DIR, "node_" + number) : Paths.get(this.dataPath, new String[0]);
        this.createDir(homePath);
        this.createDir(confPath);
        this.createDir(logsPath);
        this.createDir(dataPath);
        Settings.Builder settingsBuilder = Settings.builder();
        if (this.builder != null) {
            this.builder.build(number, settingsBuilder);
        }
        this.putIfAbsent(settingsBuilder, "path.home", homePath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.conf", confPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.data", dataPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.logs", logsPath.toAbsolutePath().toString());
        Path esConfPath = confPath.resolve(ELASTICSEARCH_YAML);
        if (!esConfPath.toFile().exists()) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/elasticsearch.yml");){
                Files.copy(is, esConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create: " + esConfPath, e);
            }
        }
        if (!this.disableESLogger && !(logConfPath = confPath.resolve(LOG4J2_PROPERTIES)).toFile().exists()) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/log4j2.properties");){
                Files.copy(is, logConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create: " + logConfPath, e);
            }
        }
        if ((pluginPath = settingsBuilder.get("path.plugins")) != null) {
            final Path sourcePath = Paths.get(pluginPath, new String[0]);
            final Path targetPath = Paths.get(this.basePath, "plugins");
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
            settingsBuilder.remove("path.plugins");
        }
        String nodeName = "Node " + number;
        int transportPort = this.getAvailableTransportPort(number);
        int httpPort = this.getAvailableHttpPort(number);
        this.putIfAbsent(settingsBuilder, "cluster.name", this.clusterName);
        this.putIfAbsent(settingsBuilder, NODE_NAME, nodeName);
        this.putIfAbsent(settingsBuilder, "node.master", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "node.data", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "http.enabled", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "transport.tcp.port", String.valueOf(transportPort));
        this.putIfAbsent(settingsBuilder, "http.port", String.valueOf(httpPort));
        this.putIfAbsent(settingsBuilder, "index.store.type", this.indexStoreType);
        this.print("Node Name:      " + nodeName);
        this.print("HTTP Port:      " + httpPort);
        this.print("Transport Port: " + transportPort);
        this.print("Data Directory: " + dataPath);
        this.print("Log Directory:  " + logsPath);
        this.print("----------------------------------------");
        Settings settings = settingsBuilder.build();
        Environment environment = new Environment(settings);
        if (!this.disableESLogger) {
            LogConfigurator.registerErrorListener();
            LogConfigurator.configure((Environment)environment);
        }
        this.createDir(environment.modulesFile());
        this.createDir(environment.pluginsFile());
        return settings;
    }

    protected int getAvailableHttpPort(int number) {
        int httpPort = this.baseHttpPort + number;
        if (this.maxHttpPort < 0) {
            return httpPort;
        }
        while (httpPort <= this.maxHttpPort) {
            try {
                Socket socket = new Socket("localhost", httpPort);
                Throwable throwable = null;
                try {
                    ++httpPort;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (ConnectException e) {
                return httpPort;
            }
            catch (IOException e) {
                this.print(e.getMessage());
                ++httpPort;
            }
        }
        throw new ClusterRunnerException("The http port " + httpPort + " is unavailable.");
    }

    protected int getAvailableTransportPort(int number) {
        int transportPort = this.baseTransportPort + number;
        if (this.maxTransportPort < 0) {
            return transportPort;
        }
        while (transportPort <= this.maxTransportPort) {
            try {
                Socket socket = new Socket("localhost", transportPort);
                Throwable throwable = null;
                try {
                    ++transportPort;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (ConnectException e) {
                return transportPort;
            }
            catch (IOException e) {
                this.print(e.getMessage());
                ++transportPort;
            }
        }
        throw new ClusterRunnerException("The transport port " + transportPort + " is unavailable.");
    }

    protected void putIfAbsent(Settings.Builder settingsBuilder, String key, String value) {
        if (settingsBuilder.get(key) == null && value != null) {
            settingsBuilder.put(key, value);
        }
    }

    public void setMaxHttpPort(int maxHttpPort) {
        this.maxHttpPort = maxHttpPort;
    }

    public void setMaxTransportPort(int maxTransportPort) {
        this.maxTransportPort = maxTransportPort;
    }

    public Node getNode(int i) {
        if (i < 0 || i >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(i);
    }

    public boolean startNode(int i) {
        if (i >= this.nodeList.size()) {
            return false;
        }
        if (!this.nodeList.get(i).isClosed()) {
            return false;
        }
        ClusterRunnerNode node = new ClusterRunnerNode(this.settingsList.get(i), this.pluginList);
        try {
            node.start();
            this.nodeList.set(i, node);
            return true;
        }
        catch (NodeValidationException e) {
            this.print(e.getLocalizedMessage());
            return false;
        }
    }

    public Node getNode(String name) {
        if (name == null) {
            return null;
        }
        for (Node node : this.nodeList) {
            if (!name.equals(node.settings().get(NODE_NAME))) continue;
            return node;
        }
        return null;
    }

    public int getNodeIndex(Node node) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!this.nodeList.get(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    public int getNodeSize() {
        return this.nodeList.size();
    }

    public void print(String line) {
        if (this.useLogger) {
            logger.info(line);
        } else {
            System.out.println(line);
        }
    }

    protected void createDir(Path path) {
        if (!path.toFile().exists()) {
            this.print("Creating " + path);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Failed to create " + path, e);
            }
        }
    }

    public Node node() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return node;
        }
        throw new ClusterRunnerException("All nodes are closed.");
    }

    public synchronized Node masterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().getMasterNode().getName();
        return this.getNode(name);
    }

    public synchronized Node nonMasterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().getMasterNode().getName();
        for (Node node : this.nodeList) {
            if (node.isClosed() || name.equals(node.settings().get(NODE_NAME))) continue;
            return node;
        }
        return null;
    }

    public Client client() {
        return this.node().client();
    }

    public AdminClient admin() {
        return this.client().admin();
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureGreen timed out, cluster state:\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForNoRelocatingShards(true).waitForYellowStatus().waitForEvents(Priority.LANGUID)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureYellow timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus waitForRelocation() {
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])new String[0]).waitForNoRelocatingShards(true);
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(request).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("waitForRelocation timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public FlushResponse flush() {
        return this.flush(true);
    }

    public FlushResponse flush(boolean force) {
        return this.flush(builder -> builder.setWaitIfOngoing(true).setForce(force));
    }

    public FlushResponse flush(BuilderCallback<FlushRequestBuilder> builder) {
        this.waitForRelocation();
        FlushResponse actionGet = (FlushResponse)builder.apply(this.client().admin().indices().prepareFlush(new String[0])).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (ShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public RefreshResponse refresh() {
        return this.refresh(builder -> builder);
    }

    public RefreshResponse refresh(BuilderCallback<RefreshRequestBuilder> builder) {
        this.waitForRelocation();
        RefreshResponse actionGet = (RefreshResponse)builder.apply(this.client().admin().indices().prepareRefresh(new String[0])).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (ShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public UpgradeResponse upgrade() {
        return this.upgrade(true);
    }

    public UpgradeResponse upgrade(boolean upgradeOnlyAncientSegments) {
        return this.upgrade(builder -> builder.setUpgradeOnlyAncientSegments(upgradeOnlyAncientSegments));
    }

    public UpgradeResponse upgrade(BuilderCallback<UpgradeRequestBuilder> builder) {
        this.waitForRelocation();
        UpgradeResponse actionGet = (UpgradeResponse)builder.apply(this.client().admin().indices().prepareUpgrade(new String[0])).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (ShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public ForceMergeResponse forceMerge() {
        return this.forceMerge(-1, false, true);
    }

    public ForceMergeResponse forceMerge(int maxNumSegments, boolean onlyExpungeDeletes, boolean flush) {
        return this.forceMerge(builder -> builder.setMaxNumSegments(maxNumSegments).setOnlyExpungeDeletes(onlyExpungeDeletes).setFlush(flush));
    }

    public ForceMergeResponse forceMerge(BuilderCallback<ForceMergeRequestBuilder> builder) {
        this.waitForRelocation();
        ForceMergeResponse actionGet = (ForceMergeResponse)builder.apply(this.client().admin().indices().prepareForceMerge(new String[0])).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (ShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public OpenIndexResponse openIndex(String index) {
        return this.openIndex(index, builder -> builder);
    }

    public OpenIndexResponse openIndex(String index, BuilderCallback<OpenIndexRequestBuilder> builder) {
        OpenIndexResponse actionGet = (OpenIndexResponse)builder.apply(this.client().admin().indices().prepareOpen(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to open " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public CloseIndexResponse closeIndex(String index) {
        return this.closeIndex(index, builder -> builder);
    }

    public CloseIndexResponse closeIndex(String index, BuilderCallback<CloseIndexRequestBuilder> builder) {
        CloseIndexResponse actionGet = (CloseIndexResponse)builder.apply(this.client().admin().indices().prepareClose(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to close " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public CreateIndexResponse createIndex(String index, Settings settings) {
        return this.createIndex(index, (CreateIndexRequestBuilder builder) -> builder.setSettings(settings != null ? settings : Settings.Builder.EMPTY_SETTINGS));
    }

    public CreateIndexResponse createIndex(String index, BuilderCallback<CreateIndexRequestBuilder> builder) {
        CreateIndexResponse actionGet = (CreateIndexResponse)builder.apply(this.client().admin().indices().prepareCreate(index)).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public boolean indexExists(String index) {
        return this.indexExists(index, builder -> builder);
    }

    public boolean indexExists(String index, BuilderCallback<IndicesExistsRequestBuilder> builder) {
        IndicesExistsResponse actionGet = (IndicesExistsResponse)builder.apply(this.client().admin().indices().prepareExists(new String[]{index})).execute().actionGet();
        return actionGet.isExists();
    }

    public DeleteIndexResponse deleteIndex(String index) {
        return this.deleteIndex(index, builder -> builder);
    }

    public DeleteIndexResponse deleteIndex(String index, BuilderCallback<DeleteIndexRequestBuilder> builder) {
        DeleteIndexResponse actionGet = (DeleteIndexResponse)builder.apply(this.client().admin().indices().prepareDelete(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public PutMappingResponse createMapping(String index, String type, String mappingSource) {
        return this.createMapping(index, builder -> builder.setType(type).setSource(mappingSource, XContentFactory.xContentType((CharSequence)mappingSource)));
    }

    public PutMappingResponse createMapping(String index, String type, XContentBuilder source) {
        return this.createMapping(index, builder -> builder.setType(type).setSource(source));
    }

    public PutMappingResponse createMapping(String index, BuilderCallback<PutMappingRequestBuilder> builder) {
        PutMappingResponse actionGet = (PutMappingResponse)builder.apply(this.client().admin().indices().preparePutMapping(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create a mapping for " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public IndexResponse insert(String index, String type, String id, String source) {
        return this.insert(index, type, id, (IndexRequestBuilder builder) -> (IndexRequestBuilder)builder.setSource(source, XContentFactory.xContentType((CharSequence)source)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE));
    }

    public IndexResponse insert(String index, String type, String id, BuilderCallback<IndexRequestBuilder> builder) {
        IndexResponse actionGet = (IndexResponse)builder.apply(this.client().prepareIndex(index, type, id)).execute().actionGet();
        if (actionGet.getResult() != DocWriteResponse.Result.CREATED) {
            this.onFailure("Failed to insert " + id + " into " + index + "/" + type + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public DeleteResponse delete(String index, String type, String id) {
        return this.delete(index, type, id, builder -> (DeleteRequestBuilder)builder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE));
    }

    public DeleteResponse delete(String index, String type, String id, BuilderCallback<DeleteRequestBuilder> builder) {
        DeleteResponse actionGet = (DeleteResponse)builder.apply(this.client().prepareDelete(index, type, id)).execute().actionGet();
        if (actionGet.getResult() != DocWriteResponse.Result.DELETED) {
            this.onFailure("Failed to delete " + id + " from " + index + "/" + type + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public SearchResponse count(String index, String type) {
        return this.count(index, (SearchRequestBuilder builder) -> builder.setTypes(new String[]{type}));
    }

    public SearchResponse count(String index, BuilderCallback<SearchRequestBuilder> builder) {
        return (SearchResponse)builder.apply(this.client().prepareSearch(new String[]{index}).setSize(0)).execute().actionGet();
    }

    public SearchResponse search(String index, String type, QueryBuilder queryBuilder, SortBuilder<?> sort, int from, int size) {
        return this.search(index, builder -> builder.setTypes(new String[]{type}).setQuery((QueryBuilder)(queryBuilder != null ? queryBuilder : QueryBuilders.matchAllQuery())).addSort((SortBuilder)(sort != null ? sort : SortBuilders.scoreSort())).setFrom(from).setSize(size));
    }

    public SearchResponse search(String index, BuilderCallback<SearchRequestBuilder> builder) {
        return (SearchResponse)builder.apply(this.client().prepareSearch(new String[]{index})).execute().actionGet();
    }

    public GetAliasesResponse getAlias(String alias) {
        return this.getAlias(alias, builder -> builder);
    }

    public GetAliasesResponse getAlias(String alias, BuilderCallback<GetAliasesRequestBuilder> builder) {
        return (GetAliasesResponse)builder.apply(this.client().admin().indices().prepareGetAliases(new String[]{alias})).execute().actionGet();
    }

    public IndicesAliasesResponse updateAlias(String alias, String[] addedIndices, String[] deletedIndices) {
        return this.updateAlias(builder -> {
            if (addedIndices != null && addedIndices.length > 0) {
                builder.addAlias(addedIndices, alias);
            }
            if (deletedIndices != null && deletedIndices.length > 0) {
                builder.removeAlias(deletedIndices, new String[]{alias});
            }
            return builder;
        });
    }

    public IndicesAliasesResponse updateAlias(BuilderCallback<IndicesAliasesRequestBuilder> builder) {
        IndicesAliasesResponse actionGet = (IndicesAliasesResponse)builder.apply(this.client().admin().indices().prepareAliases()).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to update aliases.", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public ClusterService clusterService() {
        return this.getInstance(ClusterService.class);
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        Node node = this.masterNode();
        return (T)node.injector().getInstance(clazz);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private void onFailure(String message, ActionResponse response) {
        if (!this.printOnFailure) {
            throw new ClusterRunnerException(message, response);
        }
        this.print(message);
    }

    public static Configs newConfigs() {
        return new Configs();
    }

    public static interface BuilderCallback<T> {
        public T apply(T var1);
    }

    public static class Configs {
        List<String> configList = new ArrayList<String>();

        public Configs basePath(String basePath) {
            this.configList.add("-basePath");
            this.configList.add(basePath);
            return this;
        }

        public Configs numOfNode(int numOfNode) {
            this.configList.add("-numOfNode");
            this.configList.add(String.valueOf(numOfNode));
            return this;
        }

        public Configs baseTransportPort(int baseTransportPort) {
            this.configList.add("-baseTransportPort");
            this.configList.add(String.valueOf(baseTransportPort));
            return this;
        }

        public Configs baseHttpPort(int baseHttpPort) {
            this.configList.add("-baseHttpPort");
            this.configList.add(String.valueOf(baseHttpPort));
            return this;
        }

        public Configs clusterName(String clusterName) {
            this.configList.add("-clusterName");
            this.configList.add(clusterName);
            return this;
        }

        public Configs indexStoreType(String indexStoreType) {
            this.configList.add("-indexStoreType");
            this.configList.add(indexStoreType);
            return this;
        }

        public Configs useLogger() {
            this.configList.add("-useLogger");
            return this;
        }

        public Configs disableESLogger() {
            this.configList.add("-disableESLogger");
            return this;
        }

        public Configs printOnFailure() {
            this.configList.add("-printOnFailure");
            return this;
        }

        public Configs moduleTypes(String moduleTypes) {
            this.configList.add("-moduleTypes");
            this.configList.add(moduleTypes);
            return this;
        }

        public Configs pluginTypes(String pluginTypes) {
            this.configList.add("-pluginTypes");
            this.configList.add(pluginTypes);
            return this;
        }

        public String[] build() {
            return this.configList.toArray(new String[this.configList.size()]);
        }
    }

    public static interface Builder {
        public void build(int var1, Settings.Builder var2);
    }

    private static final class CleanUpFileVisitor
    implements FileVisitor<Path> {
        private final List<Throwable> errorList = new ArrayList<Throwable>();

        private CleanUpFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public boolean hasErrors() {
            return !this.errorList.isEmpty();
        }

        public List<Throwable> getErrors() {
            return this.errorList;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return this.checkIfExist(file);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                Files.delete(dir);
                if (dir.toFile().exists()) {
                    this.errorList.add(new IOException("Failed to delete " + dir));
                    dir.toFile().deleteOnExit();
                }
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }

        private FileVisitResult checkIfExist(Path path) throws IOException {
            if (path.toFile().exists()) {
                this.errorList.add(new IOException("Failed to delete " + path));
                path.toFile().deleteOnExit();
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

