/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.codelibs.elasticsearch.runner.net.CurlException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class CurlResponse
implements Closeable {
    private int httpStatusCode;
    private Path tempFile;
    private String encoding;
    private Exception contentException;

    @Override
    public void close() throws IOException {
        if (this.tempFile != null) {
            Files.delete(this.tempFile);
        }
    }

    public Map<String, Object> getContentAsMap() {
        Map map;
        block8: {
            InputStream is = this.getContentAsStream();
            try {
                map = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, is).map();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CurlException("Failed to access the content.", e);
                }
            }
            is.close();
        }
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString() {
        byte[] bytes = new byte[4096];
        try (BufferedInputStream bis = new BufferedInputStream(this.getContentAsStream());){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length = bis.read(bytes);
                while (length != -1) {
                    if (length != 0) {
                        baos.write(bytes, 0, length);
                    }
                    length = bis.read(bytes);
                }
                string = baos.toString(this.encoding);
            }
            return string;
        }
        catch (Exception e) {
            throw new CurlException("Failed to access the content.", e);
        }
    }

    public InputStream getContentAsStream() throws IOException {
        if (this.tempFile == null) {
            if (this.contentException != null) {
                throw new CurlException("The content does not exist.", this.contentException);
            }
            throw new CurlException("The content does not exist.");
        }
        return Files.newInputStream(this.tempFile, StandardOpenOption.READ);
    }

    public void setContentFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setContentException(Exception e) {
        this.contentException = e;
    }

    public Exception getContentException() {
        return this.contentException;
    }
}

