/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.codelibs.elasticsearch.runner.net.Curl;
import org.codelibs.elasticsearch.runner.net.CurlException;
import org.codelibs.elasticsearch.runner.net.CurlResponse;
import org.elasticsearch.node.Node;

public class CurlRequest {
    protected String url;
    protected Proxy proxy;
    protected String encoding = "UTF-8";
    protected Curl.Method method;
    protected List<String> paramList;
    protected List<String[]> headerList;
    protected String body;
    private ConnectionBuilder connectionBuilder;

    public CurlRequest(Curl.Method method, String url) {
        this.method = method;
        this.url = url;
    }

    public CurlRequest(Curl.Method method, Node node, String path) {
        this.method = method;
        StringBuilder urlBuf = new StringBuilder(200);
        urlBuf.append("http://localhost:").append(node.settings().get("http.port"));
        if (path.startsWith("/")) {
            urlBuf.append(path);
        } else {
            urlBuf.append('/').append(path);
        }
        this.url = urlBuf.toString();
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public String encoding() {
        return this.encoding;
    }

    public Curl.Method method() {
        return this.method;
    }

    public String body() {
        return this.body;
    }

    public CurlRequest proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public CurlRequest encoding(String encoding) {
        if (this.paramList != null) {
            throw new CurlException("This method must be called before param method.");
        }
        this.encoding = encoding;
        return this;
    }

    public CurlRequest body(String body) {
        this.body = body;
        return this;
    }

    public CurlRequest onConnect(ConnectionBuilder connectionBuilder) {
        this.connectionBuilder = connectionBuilder;
        return this;
    }

    public CurlRequest param(String key, String value) {
        if (this.paramList == null) {
            this.paramList = new ArrayList<String>();
        }
        this.paramList.add(this.encode(key) + "=" + this.encode(value));
        return this;
    }

    public CurlRequest header(String key, String value) {
        if (this.headerList == null) {
            this.headerList = new ArrayList<String[]>();
        }
        this.headerList.add(new String[]{key, value});
        return this;
    }

    public void execute(Curl.ResponseListener listener) {
        if (this.paramList != null) {
            int sp = this.url.indexOf(63) == -1 ? 63 : 38;
            StringBuilder urlBuf = new StringBuilder(100);
            for (String param : this.paramList) {
                urlBuf.append((char)sp).append(param);
                if (sp != 63) continue;
                sp = 38;
            }
            this.url = this.url + urlBuf.toString();
        }
        HttpURLConnection connection = null;
        try {
            URL u = new URL(this.url);
            connection = (HttpURLConnection)(this.proxy != null ? u.openConnection(this.proxy) : u.openConnection());
            connection.setRequestMethod(this.method.toString());
            if (this.headerList != null) {
                for (String[] values : this.headerList) {
                    connection.addRequestProperty(values[0], values[1]);
                }
            }
            if (this.connectionBuilder != null) {
                this.connectionBuilder.onConnect(this, connection);
            } else if (this.body != null) {
                connection.setDoOutput(true);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), this.encoding));){
                    writer.write(this.body);
                    writer.flush();
                }
            }
            listener.onResponse(connection);
        }
        catch (Exception e) {
            throw new CurlException("Failed to access to " + this.url, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public CurlResponse execute() {
        final CurlResponse response = new CurlResponse();
        this.execute(new Curl.ResponseListener(){

            @Override
            public void onResponse(HttpURLConnection con) {
                try {
                    response.setEncoding(CurlRequest.this.encoding);
                    response.setHttpStatusCode(con.getResponseCode());
                    this.writeContent(() -> con.getInputStream());
                }
                catch (Exception e) {
                    InputStream errorStream = con.getErrorStream();
                    if (errorStream != null) {
                        this.writeContent(() -> errorStream);
                        response.setContentException(e);
                    }
                    throw new CurlException("Failed to access the response.", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeContent(InputStreamHandler handler) {
                Path tempFile;
                try {
                    tempFile = Files.createTempFile("esrunner-", ".tmp", new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new CurlException("Failed to create a temporary file.", e);
                }
                try (BufferedInputStream bis = new BufferedInputStream(handler.open());
                     BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(tempFile, StandardOpenOption.WRITE));){
                    byte[] bytes = new byte[4096];
                    try {
                        int length = bis.read(bytes);
                        while (length != -1) {
                            if (length != 0) {
                                bos.write(bytes, 0, length);
                            }
                            length = bis.read(bytes);
                        }
                    }
                    finally {
                        bytes = null;
                    }
                    bos.flush();
                    response.setContentFile(tempFile);
                }
                catch (Exception e) {
                    response.setContentException(e);
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return response;
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CurlException("Invalid encoding: " + this.encoding, e);
        }
    }

    public static interface ConnectionBuilder {
        public void onConnect(CurlRequest var1, HttpURLConnection var2);
    }

    private static interface InputStreamHandler {
        public InputStream open() throws IOException;
    }
}

