/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.codelibs.elasticsearch.runner.ClusterRunnerException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.optimize.OptimizeResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.log4j.LogConfigurator;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ElasticsearchClusterRunner {
    private static final ESLogger logger = Loggers.getLogger((String)"codelibs.cluster.runner");
    protected static final String LOGGING_YAML = "logging.yml";
    protected static final String ELASTICSEARCH_YAML = "elasticsearch.yml";
    protected static final String WORK_DIR = "work";
    protected static final String DATA_DIR = "data";
    protected static final String LOGS_DIR = "logs";
    protected static final String PLUGINS_DIR = "plugins";
    protected static final String CONFIG_DIR = "config";
    protected List<Node> nodeList = new ArrayList<Node>();
    protected List<Settings> settingsList = new ArrayList<Settings>();
    protected int maxHttpPort = 9299;
    protected int maxTransportPort = 9399;
    @Option(name="-basePath", usage="Base path for Elasticsearch.")
    protected String basePath;
    @Option(name="-numOfNode", usage="The number of Elasticsearch node.")
    protected int numOfNode = 3;
    @Option(name="-baseTransportPort", usage="Base transport port.")
    protected int baseTransportPort = 9300;
    @Option(name="-baseHttpPort", usage="Base http port.")
    protected int baseHttpPort = 9200;
    @Option(name="-clusterName", usage="Cluster name.")
    protected String clusterName = "elasticsearch-cluster-runner";
    @Option(name="-indexStoreType", usage="Index store type.")
    protected String indexStoreType = "default";
    @Option(name="-useLogger", usage="Print logs to a logger.")
    protected boolean useLogger = false;
    @Option(name="-printOnFailure", usage="Print an exception on a failure.")
    protected boolean printOnFailure = false;
    protected Builder builder;

    public static void main(String[] args) {
        final ElasticsearchClusterRunner runner = new ElasticsearchClusterRunner();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                runner.close();
            }
        });
        runner.build(args);
        while (!runner.isClosed()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isClosed() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        for (Node node : this.nodeList) {
            node.close();
        }
        this.print("Closed all nodes.");
    }

    public void clean() {
        Path bPath = FileSystems.getDefault().getPath(this.basePath, new String[0]);
        for (int i = 0; i < 3; ++i) {
            try {
                CleanUpFileVisitor visitor = new CleanUpFileVisitor();
                Files.walkFileTree(bPath, visitor);
                if (!visitor.hasErrors()) {
                    this.print("Deleted " + this.basePath);
                    return;
                }
                if (!logger.isDebugEnabled()) continue;
                for (Throwable t : visitor.getErrors()) {
                    logger.debug("Could not delete files/directories.", t, new Object[0]);
                }
                continue;
            }
            catch (Exception e) {
                this.print(e.getMessage() + " Retring to delete it.");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        this.print("Failed to delete " + this.basePath + " in this process.");
    }

    public ElasticsearchClusterRunner onBuild(Builder builder) {
        this.builder = builder;
        return this;
    }

    public void build(Configs configs) {
        this.build(configs.build());
    }

    public void build(String ... args) {
        Path logConfPath;
        if (args != null) {
            CmdLineParser parser = new CmdLineParser((Object)this);
            parser.setUsageWidth(80);
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                throw new ClusterRunnerException("Failed to parse args: " + Strings.arrayToDelimitedString((Object[])args, (String)" "));
            }
        }
        if (this.basePath == null) {
            try {
                this.basePath = Files.createTempDirectory("es-cluster", new FileAttribute[0]).toAbsolutePath().toString();
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create $ES_HOME.", e);
            }
        }
        Path esBasePath = Paths.get(this.basePath, new String[0]);
        this.createDir(esBasePath);
        Path confPath = Paths.get(this.basePath, CONFIG_DIR);
        this.createDir(confPath);
        Path esConfPath = confPath.resolve(ELASTICSEARCH_YAML);
        if (!Files.exists(esConfPath, new LinkOption[0])) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/elasticsearch.yml");){
                Files.copy(is, esConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create: " + esConfPath, e);
            }
        }
        if (!Files.exists(logConfPath = confPath.resolve(LOGGING_YAML), new LinkOption[0])) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/logging.yml");){
                Files.copy(is, logConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Could not create: " + logConfPath, e);
            }
        }
        this.print("----------------------------------------");
        this.print("Cluster Name: " + this.clusterName);
        this.print("Base Path:    " + this.basePath);
        this.print("Num Of Node:  " + this.numOfNode);
        this.print("----------------------------------------");
        for (int i = 0; i < this.numOfNode; ++i) {
            Settings settings = this.buildNodeSettings(i + 1);
            InternalNode node = new InternalNode(settings, true);
            node.start();
            this.nodeList.add((Node)node);
            this.settingsList.add(settings);
        }
    }

    protected Settings buildNodeSettings(int number) {
        Path confPath = Paths.get(this.basePath, CONFIG_DIR);
        Path pluginsPath = Paths.get(this.basePath, PLUGINS_DIR);
        Path logsPath = Paths.get(this.basePath, LOGS_DIR, "node_" + number);
        Path dataPath = Paths.get(this.basePath, DATA_DIR, "node_" + number);
        Path workPath = Paths.get(this.basePath, WORK_DIR, "node_" + number);
        this.createDir(logsPath);
        this.createDir(dataPath);
        this.createDir(workPath);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        if (this.builder != null) {
            this.builder.build(number, settingsBuilder);
        }
        this.putIfAbsent(settingsBuilder, "path.conf", confPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.data", dataPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.work", workPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.logs", logsPath.toAbsolutePath().toString());
        this.putIfAbsent(settingsBuilder, "path.plugins", pluginsPath.toAbsolutePath().toString());
        String nodeName = "Node " + number;
        int transportPort = this.getAvailableTransportPort(number);
        int httpPort = this.getAvailableHttpPort(number);
        this.putIfAbsent(settingsBuilder, "cluster.name", this.clusterName);
        this.putIfAbsent(settingsBuilder, "node.name", nodeName);
        this.putIfAbsent(settingsBuilder, "node.master", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "node.data", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "http.enabled", String.valueOf(true));
        this.putIfAbsent(settingsBuilder, "transport.tcp.port", String.valueOf(transportPort));
        this.putIfAbsent(settingsBuilder, "http.port", String.valueOf(httpPort));
        this.putIfAbsent(settingsBuilder, "index.store.type", this.indexStoreType);
        this.print("Node Name:      " + nodeName);
        this.print("HTTP Port:      " + httpPort);
        this.print("Transport Port: " + transportPort);
        this.print("Data Directory: " + dataPath);
        this.print("Log Directory:  " + logsPath);
        this.print("----------------------------------------");
        Settings settings = settingsBuilder.build();
        LogConfigurator.configure((Settings)settings);
        return settings;
    }

    protected int getAvailableHttpPort(int number) {
        int httpPort = this.baseHttpPort + number;
        if (this.maxHttpPort < 0) {
            return httpPort;
        }
        while (httpPort <= this.maxHttpPort) {
            try {
                Socket socket = new Socket("localhost", httpPort);
                Throwable throwable = null;
                try {
                    ++httpPort;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (ConnectException e) {
                return httpPort;
            }
            catch (IOException e) {
                this.print(e.getMessage());
                ++httpPort;
            }
        }
        throw new ClusterRunnerException("The http port " + httpPort + " is unavailable.");
    }

    protected int getAvailableTransportPort(int number) {
        int transportPort = this.baseTransportPort + number;
        if (this.maxTransportPort < 0) {
            return transportPort;
        }
        while (transportPort <= this.maxTransportPort) {
            try {
                Socket socket = new Socket("localhost", transportPort);
                Throwable throwable = null;
                try {
                    ++transportPort;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (ConnectException e) {
                return transportPort;
            }
            catch (IOException e) {
                this.print(e.getMessage());
                ++transportPort;
            }
        }
        throw new ClusterRunnerException("The transport port " + transportPort + " is unavailable.");
    }

    protected void putIfAbsent(ImmutableSettings.Builder settingsBuilder, String key, String value) {
        if (settingsBuilder.get(key) == null && value != null) {
            settingsBuilder.put(key, value);
        }
    }

    public void setMaxHttpPort(int maxHttpPort) {
        this.maxHttpPort = maxHttpPort;
    }

    public void setMaxTransportPort(int maxTransportPort) {
        this.maxTransportPort = maxTransportPort;
    }

    public Node getNode(int i) {
        if (i < 0 || i >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(i);
    }

    public boolean startNode(int i) {
        if (i >= this.nodeList.size()) {
            return false;
        }
        if (!this.nodeList.get(i).isClosed()) {
            return false;
        }
        InternalNode node = new InternalNode(this.settingsList.get(i), true);
        node.start();
        this.nodeList.set(i, (Node)node);
        return true;
    }

    public Node getNode(String name) {
        if (name == null) {
            return null;
        }
        for (Node node : this.nodeList) {
            if (!name.equals(node.settings().get("name"))) continue;
            return node;
        }
        return null;
    }

    public int getNodeIndex(Node node) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!this.nodeList.get(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    public int getNodeSize() {
        return this.nodeList.size();
    }

    public void print(String line) {
        if (this.useLogger) {
            logger.info(line, new Object[0]);
        } else {
            System.out.println(line);
        }
    }

    protected void createDir(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            this.print("Creating " + path);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ClusterRunnerException("Failed to create " + path, e);
            }
        }
    }

    public Node node() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return node;
        }
        throw new ClusterRunnerException("All nodes are closed.");
    }

    public synchronized Node masterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().masterNode().name();
        return this.getNode(name);
    }

    public synchronized Node nonMasterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().masterNode().name();
        for (Node node : this.nodeList) {
            if (node.isClosed() || name.equals(node.settings().get("name"))) continue;
            return node;
        }
        return null;
    }

    public Client client() {
        return this.node().client();
    }

    public AdminClient admin() {
        return this.client().admin();
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForRelocatingShards(0)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureGreen timed out, cluster state:\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState().prettyPrint() + "\n" + ((PendingClusterTasksResponse)this.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForRelocatingShards(0).waitForYellowStatus().waitForEvents(Priority.LANGUID)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureYellow timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState().prettyPrint() + "\n" + ((PendingClusterTasksResponse)this.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus waitForRelocation() {
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])new String[0]).waitForRelocatingShards(0);
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(request).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("waitForRelocation timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState().prettyPrint() + "\n" + ((PendingClusterTasksResponse)this.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public FlushResponse flush() {
        return this.flush(true);
    }

    public FlushResponse flush(boolean force) {
        this.waitForRelocation();
        FlushResponse actionGet = (FlushResponse)this.client().admin().indices().prepareFlush(new String[0]).setWaitIfOngoing(true).setForce(force).setFull(true).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            this.onFailure(shardFailures.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public RefreshResponse refresh() {
        return this.refresh(true);
    }

    public RefreshResponse refresh(boolean force) {
        this.waitForRelocation();
        RefreshResponse actionGet = (RefreshResponse)this.client().admin().indices().prepareRefresh(new String[0]).setForce(force).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            this.onFailure(shardFailures.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public OptimizeResponse optimize(boolean force) {
        this.waitForRelocation();
        OptimizeResponse actionGet = (OptimizeResponse)this.client().admin().indices().prepareOptimize(new String[0]).setForce(force).execute().actionGet();
        ShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            this.onFailure(shardFailures.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public CreateIndexResponse createIndex(String index, Settings settings) {
        CreateIndexResponse actionGet = (CreateIndexResponse)this.client().admin().indices().prepareCreate(index).setSettings(settings != null ? settings : ImmutableSettings.Builder.EMPTY_SETTINGS).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public boolean indexExists(String index) {
        IndicesExistsResponse actionGet = (IndicesExistsResponse)this.client().admin().indices().prepareExists(new String[]{index}).execute().actionGet();
        return actionGet.isExists();
    }

    public DeleteIndexResponse deleteIndex(String index) {
        DeleteIndexResponse actionGet = (DeleteIndexResponse)this.client().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public PutMappingResponse createMapping(String index, String type, String mappnigSource) {
        PutMappingResponse actionGet = (PutMappingResponse)this.client().admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(mappnigSource).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create a mapping for " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public PutMappingResponse createMapping(String index, String type, XContentBuilder source) {
        PutMappingResponse actionGet = (PutMappingResponse)this.client().admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(source).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create a mapping for " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public IndexResponse insert(String index, String type, String id, String source) {
        IndexResponse actionGet = (IndexResponse)this.client().prepareIndex(index, type, id).setSource(source).setRefresh(true).execute().actionGet();
        if (!actionGet.isCreated()) {
            this.onFailure("Failed to insert " + id + " into " + index + "/" + type + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public DeleteResponse delete(String index, String type, String id) {
        DeleteResponse actionGet = (DeleteResponse)this.client().prepareDelete(index, type, id).setRefresh(true).execute().actionGet();
        if (!actionGet.isFound()) {
            this.onFailure("Failed to delete " + id + " from " + index + "/" + type + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public CountResponse count(String index, String type) {
        CountResponse actionGet = (CountResponse)this.client().prepareCount(new String[]{index}).setTypes(new String[]{type}).execute().actionGet();
        return actionGet;
    }

    public SearchResponse search(String index, String type, QueryBuilder queryBuilder, SortBuilder sort, int from, int size) {
        SearchResponse actionGet = (SearchResponse)this.client().prepareSearch(new String[]{index}).setTypes(new String[]{type}).setQuery((QueryBuilder)(queryBuilder != null ? queryBuilder : QueryBuilders.matchAllQuery())).addSort((SortBuilder)(sort != null ? sort : SortBuilders.scoreSort())).setFrom(from).setSize(size).execute().actionGet();
        return actionGet;
    }

    public GetAliasesResponse getAlias(String alias) {
        GetAliasesResponse actionGet = (GetAliasesResponse)this.client().admin().indices().prepareGetAliases(new String[]{alias}).execute().actionGet();
        return actionGet;
    }

    public IndicesAliasesResponse updateAlias(String alias, String[] addedIndices, String[] deletedIndices) {
        IndicesAliasesResponse actionGet;
        IndicesAliasesRequestBuilder builder = this.client().admin().indices().prepareAliases();
        if (addedIndices != null && addedIndices.length > 0) {
            builder.addAlias(addedIndices, alias);
        }
        if (deletedIndices != null && deletedIndices.length > 0) {
            builder.removeAlias(deletedIndices, new String[]{alias});
        }
        if (!(actionGet = (IndicesAliasesResponse)builder.execute().actionGet()).isAcknowledged()) {
            this.onFailure("Failed to update " + alias + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public ClusterService clusterService() {
        return this.getInstance(ClusterService.class);
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        Node node = this.masterNode();
        if (node instanceof InternalNode) {
            return (T)((InternalNode)node).injector().getInstance(clazz);
        }
        return null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private void onFailure(String message, ActionResponse response) {
        if (!this.printOnFailure) {
            throw new ClusterRunnerException(message, response);
        }
        this.print(message);
    }

    public static Configs newConfigs() {
        return new Configs();
    }

    public static class Configs {
        List<String> configList = new ArrayList<String>();

        public Configs basePath(String basePath) {
            this.configList.add("-basePath");
            this.configList.add(basePath);
            return this;
        }

        public Configs numOfNode(int numOfNode) {
            this.configList.add("-numOfNode");
            this.configList.add(String.valueOf(numOfNode));
            return this;
        }

        public Configs baseTransportPort(int baseTransportPort) {
            this.configList.add("-baseTransportPort");
            this.configList.add(String.valueOf(baseTransportPort));
            return this;
        }

        public Configs baseHttpPort(int baseHttpPort) {
            this.configList.add("-baseHttpPort");
            this.configList.add(String.valueOf(baseHttpPort));
            return this;
        }

        public Configs clusterName(String clusterName) {
            this.configList.add("-clusterName");
            this.configList.add(clusterName);
            return this;
        }

        public Configs indexStoreType(String indexStoreType) {
            this.configList.add("-indexStoreType");
            this.configList.add(indexStoreType);
            return this;
        }

        public Configs ramIndexStore() {
            return this.indexStoreType("ram");
        }

        public Configs useLogger() {
            this.configList.add("-useLogger");
            return this;
        }

        public Configs printOnFailure() {
            this.configList.add("-printOnFailure");
            return this;
        }

        public String[] build() {
            return this.configList.toArray(new String[this.configList.size()]);
        }
    }

    public static interface Builder {
        public void build(int var1, ImmutableSettings.Builder var2);
    }

    private static final class CleanUpFileVisitor
    implements FileVisitor<Path> {
        private List<Throwable> errorList = new ArrayList<Throwable>();

        private CleanUpFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public boolean hasErrors() {
            return !this.errorList.isEmpty();
        }

        public List<Throwable> getErrors() {
            return this.errorList;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return this.checkIfExist(file);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                Files.delete(dir);
                if (Files.exists(dir, new LinkOption[0])) {
                    this.errorList.add(new IOException("Failed to delete " + dir));
                    dir.toFile().deleteOnExit();
                }
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }

        private FileVisitResult checkIfExist(Path path) throws IOException {
            if (Files.exists(path, new LinkOption[0])) {
                this.errorList.add(new IOException("Failed to delete " + path));
                path.toFile().deleteOnExit();
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

