/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.kuromoji.neologd.index.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.ja.PosConcatenationFilter;
import org.codelibs.neologd.ipadic.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class PosConcatenationFilterFactory
extends AbstractTokenFilterFactory {
    private Set<String> posTags = new HashSet<String>();

    public PosConcatenationFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        List tagList = Analysis.getWordList((Environment)environment, (Settings)settings, (String)"tags");
        if (tagList != null) {
            this.posTags.addAll(tagList);
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        final PartOfSpeechAttribute posAtt = (PartOfSpeechAttribute)tokenStream.addAttribute(PartOfSpeechAttribute.class);
        return new PosConcatenationFilter(tokenStream, this.posTags, new PosConcatenationFilter.PartOfSpeechSupplier(){

            public String get() {
                return posAtt.getPartOfSpeech();
            }
        });
    }
}

