/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.kuromoji.neologd.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.codelibs.neologd.ipadic.lucene.analysis.ja.JapaneseTokenizer;
import org.codelibs.neologd.ipadic.lucene.analysis.ja.dict.UserDictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.Analysis;

public class KuromojiTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_OPTION = "user_dictionary";
    private static final String NBEST_COST = "nbest_cost";
    private static final String NBEST_EXAMPLES = "nbest_examples";
    private final UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final String nBestExamples;
    private final int nBestCost;
    private boolean discartPunctuation;

    public KuromojiTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.mode = KuromojiTokenizerFactory.getMode(settings);
        this.userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.discartPunctuation = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "discard_punctuation", Boolean.valueOf(true), this.deprecationLogger);
        this.nBestCost = settings.getAsInt(NBEST_COST, Integer.valueOf(-1));
        this.nBestExamples = settings.get(NBEST_EXAMPLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserDictionary getUserDictionary(Environment env, Settings settings) {
        UserDictionary userDictionary;
        Reader reader = Analysis.getReaderFromFile((Environment)env, (Settings)settings, (String)USER_DICT_OPTION);
        if (reader == null) {
            return null;
        }
        try {
            userDictionary = UserDictionary.open((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load kuromoji user dictionary", (Throwable)e, new Object[0]);
            }
        }
        reader.close();
        return userDictionary;
    }

    public static JapaneseTokenizer.Mode getMode(Settings settings) {
        JapaneseTokenizer.Mode mode = JapaneseTokenizer.DEFAULT_MODE;
        String modeSetting = settings.get("mode", null);
        if (modeSetting != null) {
            if ("search".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.SEARCH;
            } else if ("normal".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.NORMAL;
            } else if ("extended".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.EXTENDED;
            }
        }
        return mode;
    }

    public Tokenizer create() {
        JapaneseTokenizer t = new JapaneseTokenizer(this.userDictionary, this.discartPunctuation, this.mode);
        int nBestCost = this.nBestCost;
        if (this.nBestExamples != null) {
            nBestCost = Math.max(nBestCost, t.calcNBestCost(this.nBestExamples));
        }
        t.setNBestCost(nBestCost);
        return t;
    }
}

