/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.mime.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class TikaMimeDetectUtils {
    private static final Logger logger = LoggerFactory.getLogger(TikaMimeDetectUtils.class);

    public static String getMimeType(InputStream inputStream) throws Exception {
        BodyContentHandler contentHandler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        ParseContext parseContext = new ParseContext();
        parser.parse(inputStream, (ContentHandler)contentHandler, metadata, parseContext);
        String contentType = metadata.get("Content-Type");
        logger.debug("content type: {}", (Object)contentType);
        return contentType;
    }

    public static String getMimeType(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        return TikaMimeDetectUtils.getMimeType(inputStream);
    }

    public static String getMimeType(URL url) throws Exception {
        InputStream inputStream = url.openStream();
        return TikaMimeDetectUtils.getMimeType(inputStream);
    }

    public static String getMimeType(byte[] byteArray) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        return TikaMimeDetectUtils.getMimeType(inputStream);
    }

    public static String getMimeType(String path) throws Exception {
        FileInputStream inputStream = new FileInputStream(new File(path));
        return TikaMimeDetectUtils.getMimeType(inputStream);
    }
}

