/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private Object ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        this.ecSpec = eCPublicKeySpec.getParams();
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPublicKey(String string, ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        void var6_14;
        Object object;
        ECCurve eCCurve;
        Object object2;
        ASN1Encodable aSN1Encodable;
        if (subjectPublicKeyInfo.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString aSN1OctetString;
            Object object3;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                object3 = new ASN1InputStream(dERBitString.getBytes());
                aSN1OctetString = (ASN1OctetString)((ASN1InputStream)object3).readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            object3 = aSN1OctetString.getOctets();
            byte[] byArray = new byte[32];
            byte[] byArray2 = new byte[32];
            int n = 0;
            while (n != byArray2.length) {
                byArray[n] = (byte)object3[31 - n];
                ++n;
            }
            int n2 = 0;
            while (n2 != byArray.length) {
                byArray2[n2] = (byte)object3[63 - n2];
                ++n2;
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = eCNamedCurveParameterSpec;
            ECCurve eCCurve2 = eCNamedCurveParameterSpec.getCurve();
            if (eCCurve2 instanceof ECCurve.Fp) {
                ECCurve.Fp fp = (ECCurve.Fp)eCCurve2;
                this.q = new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray)), new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray2)));
                return;
            } else {
                if (!(eCCurve2 instanceof ECCurve.F2m)) throw new UnsupportedOperationException("Subclass of ECPoint " + eCCurve2.getClass().toString() + "not supported");
                ECCurve.F2m f2m = (ECCurve.F2m)eCCurve2;
                int n3 = f2m.getM();
                int n4 = f2m.getK1();
                int n5 = f2m.getK2();
                int n6 = f2m.getK3();
                this.q = new ECPoint.F2m(f2m, new ECFieldElement.F2m(n3, n4, n5, n6, new BigInteger(1, byArray)), new ECFieldElement.F2m(n3, n4, n5, n6, new BigInteger(1, byArray2)), false);
            }
            return;
        }
        X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            object2 = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), ((X9ECParameters)object2).getSeed());
            eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
        }
        aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
        object2 = ((DERBitString)aSN1Encodable).getBytes();
        DEROctetString dEROctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            try {
                object = new ByteArrayInputStream((byte[])object2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = new X9ECPoint(eCCurve, (ASN1OctetString)var6_14);
        this.q = ((X9ECPoint)object).getPoint();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            object4 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            x962Parameters = new X962Parameters((DERObjectIdentifier)object4);
        } else {
            object4 = (ECParameterSpec)this.ecSpec;
            object3 = ((ECParameterSpec)object4).getG().getCurve();
            if (object3 instanceof ECCurve.Fp) {
                object2 = new ECPoint.Fp(((ECParameterSpec)object4).getG().getCurve(), ((ECParameterSpec)object4).getG().getX(), ((ECParameterSpec)object4).getG().getY(), this.withCompression);
            } else if (object3 instanceof ECCurve.F2m) {
                object2 = new ECPoint.F2m(((ECParameterSpec)object4).getG().getCurve(), ((ECParameterSpec)object4).getG().getX(), ((ECParameterSpec)object4).getG().getY(), this.withCompression);
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + object3.getClass().toString() + "not supported");
            }
            object = new X9ECParameters(((ECParameterSpec)object4).getCurve(), (ECPoint)object2, ((ECParameterSpec)object4).getN(), ((ECParameterSpec)object4).getH(), ((ECParameterSpec)object4).getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)object);
        }
        if (this.algorithm.equals("ECGOST3410")) {
            object3 = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(this.getQ().getCurve(), this.getQ().getX(), this.getQ().getY(), false)).getDERObject();
            object2 = this.q.getX().toBigInteger();
            object = this.q.getY().toBigInteger();
            byte[] byArray = new byte[64];
            byte[] byArray2 = ((BigInteger)object2).toByteArray();
            int n = 0;
            while (n != 32) {
                byArray[n] = byArray2[byArray2.length - 1 - n];
                ++n;
            }
            byArray2 = ((BigInteger)object).toByteArray();
            int n2 = 0;
            while (n2 != 32) {
                byArray[32 + n2] = byArray2[byArray2.length - 1 - n2];
                ++n2;
            }
            object4 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, this.gostParams.getDERObject()), new DEROctetString(byArray));
        } else {
            object3 = this.getQ().getCurve();
            if (object3 instanceof ECCurve.Fp) {
                object2 = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp((ECCurve)object3, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
            } else if (object3 instanceof ECCurve.F2m) {
                object2 = (ASN1OctetString)new X9ECPoint(new ECPoint.F2m((ECCurve)object3, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + object3.getClass().toString() + "not supported");
            }
            object4 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)object2).getOctets());
        }
        try {
            dEROutputStream.writeObject(object4);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.getQ().getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.getQ().getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }
}

