/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.tests;

import com.sonar.sslr.api.Rule;
import org.fest.assertions.GenericAssert;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.vm.EndOfInputExpression;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;
import org.sonar.sslr.tests.ParsingResultComparisonFailure;

public class RuleAssert
extends GenericAssert<RuleAssert, Rule> {
    public RuleAssert(Rule actual) {
        super(RuleAssert.class, (Object)actual);
    }

    private ParseRunner createParseRunnerWithEofMatcher() {
        this.isNotNull();
        MutableParsingRule rule = (MutableParsingRule)this.actual;
        MutableParsingRule endOfInput = (MutableParsingRule)new MutableParsingRule((GrammarRuleKey)new EndOfInput()).is(new Object[]{EndOfInputExpression.INSTANCE});
        MutableParsingRule withEndOfInput = (MutableParsingRule)new MutableParsingRule((GrammarRuleKey)new WithEndOfInput(rule.getRuleKey())).is(new Object[]{this.actual, endOfInput});
        return new ParseRunner((Rule)withEndOfInput);
    }

    public RuleAssert matches(String input) {
        ParseRunner parseRunner = this.createParseRunnerWithEofMatcher();
        ParsingResult parsingResult = parseRunner.parse(input.toCharArray());
        if (!parsingResult.isMatched()) {
            String expected = "Rule '" + this.getRuleName() + "' should match:\n" + input;
            String actual = new ParseErrorFormatter().format(parsingResult.getParseError());
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    public RuleAssert notMatches(String input) {
        ParseRunner parseRunner = this.createParseRunnerWithEofMatcher();
        ParsingResult parsingResult = parseRunner.parse(input.toCharArray());
        if (parsingResult.isMatched()) {
            throw new AssertionError((Object)("Rule '" + this.getRuleName() + "' should not match:\n" + input));
        }
        return this;
    }

    private ParseRunner createParseRunnerWithoutEofMatcher() {
        this.isNotNull();
        return new ParseRunner((Rule)this.actual);
    }

    public RuleAssert matchesPrefix(String prefixToBeMatched, String remainingInput) {
        String input;
        ParseRunner parseRunner = this.createParseRunnerWithoutEofMatcher();
        ParsingResult parsingResult = parseRunner.parse((input = prefixToBeMatched + remainingInput).toCharArray());
        if (!parsingResult.isMatched()) {
            String expected = "Rule '" + this.getRuleName() + "' should match:\n" + prefixToBeMatched + "\nwhen followed by:\n" + remainingInput;
            String actual = new ParseErrorFormatter().format(parsingResult.getParseError());
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        if (prefixToBeMatched.length() != parsingResult.getParseTreeRoot().getEndIndex()) {
            String actualMatchedPrefix = input.substring(0, parsingResult.getParseTreeRoot().getEndIndex());
            String message = "Rule '" + this.getRuleName() + "' should match:\n" + prefixToBeMatched + "\nwhen followed by:\n" + remainingInput + "\nbut matched:\n" + actualMatchedPrefix;
            throw new ParsingResultComparisonFailure(message, prefixToBeMatched, actualMatchedPrefix);
        }
        return this;
    }

    private String getRuleName() {
        return ((MutableParsingRule)this.actual).getName();
    }

    static class EndOfInput
    implements GrammarRuleKey {
        EndOfInput() {
        }

        public String toString() {
            return "end of input";
        }
    }

    static class WithEndOfInput
    implements GrammarRuleKey {
        private final GrammarRuleKey ruleKey;

        public WithEndOfInput(GrammarRuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        public String toString() {
            return this.ruleKey + " with end of input";
        }
    }
}

