/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.symboltable;

import com.sonar.sslr.api.symboltable.Scope;
import com.sonar.sslr.api.symboltable.ScopeTreeVisitor;

public class ScopeTreePrintVisitor
implements ScopeTreeVisitor {
    private int depth;
    private int totalNumberOfScopes;
    private int totalNumberOfSymbols;

    public void visitScope(Scope scope) {
        ++this.totalNumberOfScopes;
        this.totalNumberOfSymbols += scope.getMembers().size();
        System.out.print(ScopeTreePrintVisitor.pad(this.depth) + scope);
        if (!scope.getMembers().isEmpty()) {
            System.out.print(" members=" + scope.getMembers().toString());
        }
        System.out.println();
        ++this.depth;
    }

    public void leaveScope(Scope scope) {
        --this.depth;
    }

    public int getTotalNumberOfScopes() {
        return this.totalNumberOfScopes;
    }

    public int getTotalNumberOfSymbols() {
        return this.totalNumberOfSymbols;
    }

    private static String pad(int pad) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pad; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

