/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.system.internal;

import java.util.Collections;
import java.util.Map;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.jsonsimple.JSONValue;
import org.sonar.wsclient.system.Migration;
import org.sonar.wsclient.system.SystemClient;
import org.sonar.wsclient.system.internal.DefaultMigration;

public class DefaultSystemClient
implements SystemClient {
    private final HttpRequestFactory requestFactory;

    public DefaultSystemClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public Migration migrate() {
        String json = this.requestFactory.post("/api/server/setup", Collections.emptyMap());
        return this.jsonToMigration(json);
    }

    @Override
    public Migration migrate(long timeoutInMs, long rateInMs) {
        if (rateInMs >= timeoutInMs) {
            throw new IllegalArgumentException("Timeout must be greater than rate");
        }
        Migration migration = null;
        boolean running = true;
        long endAt = System.currentTimeMillis() + timeoutInMs;
        while (running && System.currentTimeMillis() < endAt) {
            migration = this.migrate();
            if (migration.status() == Migration.Status.MIGRATION_NEEDED || migration.status() == Migration.Status.MIGRATION_RUNNING) {
                this.sleepQuietly(rateInMs);
                continue;
            }
            running = false;
        }
        return migration;
    }

    @Override
    public void restart() {
        this.requestFactory.post("/api/system/restart", Collections.emptyMap());
    }

    private void sleepQuietly(long rateInMs) {
        try {
            Thread.sleep(rateInMs);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Fail to sleep!", e);
        }
    }

    private Migration jsonToMigration(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultMigration(jsonRoot);
    }
}

