/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.ManualMeasure;

public final class ManualMeasureCreateQuery
extends CreateQuery<ManualMeasure> {
    private String resourceKey;
    private String metricKey;
    private Integer intValue;
    private Double value;
    private String textValue;
    private String description;

    private ManualMeasureCreateQuery(String resourceKey, String metricKey) {
        this.resourceKey = resourceKey;
        this.metricKey = metricKey;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public Double getValue() {
        return this.value;
    }

    public ManualMeasureCreateQuery setValue(Double value) {
        this.value = value;
        return this;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public ManualMeasureCreateQuery setIntValue(Integer intValue) {
        this.intValue = intValue;
        return this;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public ManualMeasureCreateQuery setTextValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ManualMeasureCreateQuery setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/manual_measures?");
        ManualMeasureCreateQuery.appendUrlParameter(url, "resource", this.resourceKey);
        ManualMeasureCreateQuery.appendUrlParameter(url, "metric", this.metricKey);
        if (this.value != null) {
            ManualMeasureCreateQuery.appendUrlParameter(url, "val", this.value);
        } else if (this.intValue != null) {
            ManualMeasureCreateQuery.appendUrlParameter(url, "val", this.intValue);
        }
        ManualMeasureCreateQuery.appendUrlParameter(url, "text", this.textValue);
        ManualMeasureCreateQuery.appendUrlParameter(url, "desc", this.description);
        return url.toString();
    }

    @Override
    public Class<ManualMeasure> getModelClass() {
        return ManualMeasure.class;
    }

    public static ManualMeasureCreateQuery create(String resourceKey, String metricKey) {
        return new ManualMeasureCreateQuery(resourceKey, metricKey);
    }
}

