/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sonar.wsclient.internal.EncodingUtils;

public class IssueQuery {
    private final Map<String, Object> params = new HashMap<String, Object>();

    private IssueQuery() {
    }

    public static IssueQuery create() {
        return new IssueQuery();
    }

    public Map<String, Object> urlParams() {
        return this.params;
    }

    public IssueQuery issues(String ... keys) {
        return this.addParam("issues", keys);
    }

    public IssueQuery severities(String ... severities) {
        return this.addParam("severities", severities);
    }

    public IssueQuery statuses(String ... statuses) {
        return this.addParam("statuses", statuses);
    }

    public IssueQuery resolutions(String ... resolutions) {
        return this.addParam("resolutions", resolutions);
    }

    public IssueQuery components(String ... components) {
        return this.addParam("components", components);
    }

    public IssueQuery onComponentOnly(boolean onComponentOnly) {
        this.params.put("onComponentOnly", onComponentOnly);
        return this;
    }

    public IssueQuery rules(String ... s) {
        return this.addParam("rules", s);
    }

    public IssueQuery actionPlans(String ... s) {
        return this.addParam("actionPlans", s);
    }

    public IssueQuery reporters(String ... s) {
        return this.addParam("reporters", s);
    }

    public IssueQuery assignees(String ... s) {
        return this.addParam("assignees", s);
    }

    public IssueQuery languages(String ... s) {
        return this.addParam("languages", s);
    }

    public IssueQuery assigned(Boolean assigned) {
        this.params.put("assigned", assigned);
        return this;
    }

    public IssueQuery planned(Boolean planned) {
        this.params.put("planned", planned);
        return this;
    }

    public IssueQuery resolved(Boolean resolved) {
        this.params.put("resolved", resolved);
        return this;
    }

    public IssueQuery hideRules(Boolean hideRules) {
        this.params.put("hideRules", hideRules);
        return this;
    }

    public IssueQuery createdAt(Date d) {
        this.params.put("createdAt", EncodingUtils.toQueryParam(d, true));
        return this;
    }

    public IssueQuery createdAfter(Date d) {
        this.params.put("createdAfter", EncodingUtils.toQueryParam(d, true));
        return this;
    }

    public IssueQuery createdBefore(Date d) {
        this.params.put("createdBefore", EncodingUtils.toQueryParam(d, true));
        return this;
    }

    public IssueQuery sort(String sort) {
        this.params.put("sort", sort);
        return this;
    }

    public IssueQuery asc(boolean asc) {
        this.params.put("asc", asc);
        return this;
    }

    public IssueQuery pageSize(int pageSize) {
        this.params.put("pageSize", pageSize);
        return this;
    }

    public IssueQuery pageIndex(int pageIndex) {
        this.params.put("pageIndex", pageIndex);
        return this;
    }

    private IssueQuery addParam(String key, String[] values) {
        if (values != null) {
            this.params.put(key, EncodingUtils.toQueryParam(values));
        }
        return this;
    }
}

