/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class EncodingUtils {
    private static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    private EncodingUtils() {
    }

    public static Map<String, Object> toMap(String ... array) {
        if (array.length % 2 == 1) {
            throw new IllegalArgumentException("Not an even number of arguments");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < array.length; i += 2) {
            String value = array[i + 1];
            if (value == null) continue;
            map.put(array[i], array[i + 1]);
        }
        return map;
    }

    public static String toQueryParam(String[] strings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (!first) {
                sb.append(',');
            }
            sb.append(string);
            first = false;
        }
        return sb.toString();
    }

    public static String toQueryParam(Date d, boolean includeTime) {
        String format = includeTime ? DATETIME_FORMAT : DATE_FORMAT;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(d);
    }
}

