/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.Plugin;
import org.sonar.updatecenter.Release;
import org.sonar.updatecenter.Sonar;
import org.sonar.updatecenter.Update;
import org.sonar.updatecenter.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateCenter {
    private Sonar sonar = new Sonar();
    private Set<Plugin> plugins = new HashSet<Plugin>();
    private Date date;

    public UpdateCenter() {
        this(new Date());
    }

    public UpdateCenter(Date date) {
        this.date = date;
    }

    public Set<Plugin> getPlugins() {
        return this.plugins;
    }

    public Plugin getPlugin(String key) {
        for (Plugin plugin : this.plugins) {
            if (!StringUtils.equals((String)key, (String)plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    public UpdateCenter setPlugins(Collection<Plugin> plugins) {
        this.plugins.clear();
        this.plugins.addAll(plugins);
        return this;
    }

    public UpdateCenter addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public Sonar getSonar() {
        return this.sonar;
    }

    public UpdateCenter setSonar(Sonar sonar) {
        this.sonar = sonar;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public UpdateCenter setDate(Date date) {
        this.date = date;
        return this;
    }

    public List<Update> getPluginUpdates(String pluginKey, Version pluginVersion, Version sonarVersion) {
        ArrayList<Update> updates = new ArrayList<Update>();
        Plugin plugin = this.getPlugin(pluginKey);
        if (plugin != null) {
            for (Release release : plugin.getReleasesGreaterThan(pluginVersion)) {
                updates.add(Update.createForPluginRelease(release, sonarVersion));
            }
        }
        return updates;
    }

    public List<Update> getSonarUpdates(Version sonarVersion) {
        throw new NotImplementedException("TODO");
    }
}

